/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.lang.reflect.Array;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.MultidimensionalFloatFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;

@Reference(type=ReferenceType.Inproceedings, author={"Jegou, H.", "Douze, M.", "Schmid, C.", "Perez, P."}, title="Aggregating local descriptors into a compact image representation", year="2010", booktitle="Computer Vision and Pattern Recognition (CVPR), 2010 IEEE Conference on", pages={"3304 ", "3311"}, month="june", customData={"doi", "10.1109/CVPR.2010.5540039", "ISSN", "1063-6919"})
public class VLAD<T>
implements VectorAggregator<ArrayFeatureVector<T>, MultidimensionalFloatFV> {
    private HardAssigner<T, ?, ?> assigner;
    private T[] centroids;
    private boolean normalise;

    public VLAD(HardAssigner<T, ?, ?> assigner, T[] centroids, boolean normalise) {
        this.assigner = assigner;
        this.centroids = centroids;
        this.normalise = normalise;
    }

    public VLAD(HardAssigner<T, ?, ?> assigner, CentroidsProvider<T> centroids, boolean normalise) {
        this(assigner, centroids.getCentroids(), normalise);
    }

    @Override
    public MultidimensionalFloatFV aggregate(List<? extends LocalFeature<?, ? extends ArrayFeatureVector<T>>> features) {
        if (features == null || features.size() <= 0) {
            return null;
        }
        int K = this.centroids.length;
        int D = ((ArrayFeatureVector)features.get(0).getFeatureVector()).length();
        float[][] vector = new float[K][D];
        for (LocalFeature<?, ArrayFeatureVector<T>> localFeature : features) {
            Object x = ((ArrayFeatureVector)localFeature.getFeatureVector()).values;
            int i = this.assigner.assign(x);
            for (int j = 0; j < D; ++j) {
                float[] fArray = vector[i];
                int n = j;
                fArray[n] = fArray[n] + (float)(Array.getDouble(x, j) - Array.getDouble(this.centroids[i], j));
            }
        }
        return this.prepareOutput(vector);
    }

    @Override
    public MultidimensionalFloatFV aggregateVectors(List<? extends ArrayFeatureVector<T>> features) {
        if (features == null || features.size() <= 0) {
            return null;
        }
        int K = this.centroids.length;
        int D = features.get(0).length();
        float[][] vector = new float[K][D];
        for (ArrayFeatureVector<T> f : features) {
            Object x = f.values;
            int i = this.assigner.assign(x);
            for (int j = 0; j < D; ++j) {
                float[] fArray = vector[i];
                int n = j;
                fArray[n] = fArray[n] + (float)(Array.getDouble(x, j) - Array.getDouble(this.centroids[i], j));
            }
        }
        return this.prepareOutput(vector);
    }

    private MultidimensionalFloatFV prepareOutput(float[][] vector) {
        MultidimensionalFloatFV out = new MultidimensionalFloatFV(vector);
        if (this.normalise) {
            double sumsq = 0.0;
            for (int i = 0; i < ((float[])out.values).length; ++i) {
                sumsq += (double)(((float[])out.values)[i] * ((float[])out.values)[i]);
            }
            float norm = (float)(1.0 / Math.sqrt(sumsq));
            int i = 0;
            while (i < ((float[])out.values).length) {
                float[] fArray = (float[])out.values;
                int n = i++;
                fArray[n] = fArray[n] * norm;
            }
        }
        return out;
    }

    public static FImage drawDescriptor(float[] descr, int nterms, int nSpatialBins, int nOriBins) {
        FImage image = new FImage(40 * nterms, 40);
        for (int z = 0; z < nterms; ++z) {
            for (int y = 0; y < nSpatialBins; ++y) {
                for (int x = 0; x < nSpatialBins; ++x) {
                    for (int i = 0; i < nOriBins; ++i) {
                        int xx = 5 + 10 * x;
                        int yy = 5 + 10 * y;
                        int length = (int)(descr[128 * z + 16 * y + 4 * x + i] * 100.0f);
                        double theta = (double)(i * 2) * Math.PI / 8.0;
                        image.drawLine(xx + 40 * z, yy, theta, length, (Object)Float.valueOf(1.0f));
                    }
                }
            }
        }
        return image;
    }
}

