/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openimaj.feature.local.matcher.FastBasicKeypointMatcher;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.util.pair.Pair;

public class VotingKeypointMatcher<T extends Keypoint>
extends FastBasicKeypointMatcher<T>
implements LocalFeatureMatcher<T> {
    int neighbours;
    List<Pair<T>> consistentMatches = new ArrayList<Pair<T>>();
    protected int minVote;
    protected float singularityDistance;

    public VotingKeypointMatcher(int threshold) {
        this(threshold, 15, 1, 200.0f);
    }

    public VotingKeypointMatcher(int threshold, int neighbours, int minVote, float singularityDistance) {
        super(threshold);
        this.neighbours = neighbours;
        this.minVote = minVote;
        this.singularityDistance = singularityDistance;
    }

    @Override
    public List<Pair<T>> getMatches() {
        return this.consistentMatches;
    }

    public List<Pair<T>> getAllMatches() {
        return this.matches;
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        super.findMatches(keys1);
        this.consistentMatches = new ArrayList<Pair<T>>();
        for (Pair match : this.matches) {
            int vote = this.vote(match);
            if (vote <= this.minVote) continue;
            this.consistentMatches.add(match);
        }
        if (this.consistentMatches.size() == 0) {
            return false;
        }
        if (this.checkSingularity()) {
            this.consistentMatches.clear();
            return false;
        }
        return true;
    }

    protected float[] getCentroid() {
        float mx = ((Keypoint)this.consistentMatches.get((int)0).secondObject()).x;
        float my = ((Keypoint)this.consistentMatches.get((int)0).secondObject()).y;
        for (int i = 1; i < this.consistentMatches.size(); ++i) {
            mx += ((Keypoint)this.consistentMatches.get((int)i).secondObject()).x;
            my += ((Keypoint)this.consistentMatches.get((int)i).secondObject()).y;
        }
        return new float[]{mx / (float)this.consistentMatches.size(), my / (float)this.consistentMatches.size()};
    }

    protected boolean checkSingularity() {
        float[] centroid = this.getCentroid();
        Keypoint k = new Keypoint();
        k.y = centroid[1];
        k.x = centroid[0];
        for (Pair<T> p : this.consistentMatches) {
            if (!(this.euclideanSqr((Keypoint)p.secondObject(), k) > this.singularityDistance)) continue;
            return false;
        }
        return true;
    }

    protected int vote(Pair<T> match) {
        List<Keypoint> nn = this.findModelNeighbours((Keypoint)match.secondObject());
        int vote = 0;
        block0: for (Pair m : this.matches) {
            for (Keypoint k : nn) {
                if (m.secondObject() != k) continue;
                ++vote;
                continue block0;
            }
        }
        return vote;
    }

    protected float euclideanSqr(Keypoint k1, Keypoint k2) {
        return (k1.x - k2.x) * (k1.x - k2.x) + (k1.y - k2.y) * (k1.y - k2.y);
    }

    protected List<T> findModelNeighbours(final T kp) {
        class KpDist<Q extends Keypoint>
        implements Comparable<KpDist<Q>> {
            float distance;
            T keypoint;

            KpDist(T keypoint) {
                this.keypoint = keypoint;
                this.distance = this$0.euclideanSqr((Keypoint)keypoint, kp);
            }

            @Override
            public int compareTo(KpDist<Q> o) {
                if (this.distance > o.distance) {
                    return 1;
                }
                if (this.distance < o.distance) {
                    return -1;
                }
                return 0;
            }
        }
        ArrayList<KpDist> list = new ArrayList<KpDist>();
        for (Keypoint k : this.modelKeypoints) {
            list.add(new KpDist(k));
        }
        Collections.sort(list);
        ArrayList keys = new ArrayList();
        for (int i = 0; i < Math.min(this.neighbours, list.size()); ++i) {
            keys.add(((KpDist)list.get((int)i)).keypoint);
        }
        return keys;
    }
}

