/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.DenseVector;
import ch.akuhn.matrix.SparseVector;
import ch.akuhn.matrix.Util;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Vector {
    public double add(int index, double value) {
        return this.put(index, this.get(index) + value);
    }

    public double density() {
        return (double)this.used() / (double)this.size();
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new Iterator<Entry>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < Vector.this.size();
                    }

                    @Override
                    public Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new Entry(this.index, Vector.this.get(this.index++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public abstract double get(int var1);

    public double norm() {
        double sum = 0.0;
        for (Entry each : this.entries()) {
            sum += each.value * each.value;
        }
        return Math.sqrt(sum);
    }

    public abstract double put(int var1, double var2);

    public abstract int size();

    public double sum() {
        double sum = 0.0;
        for (Entry each : this.entries()) {
            sum += each.value;
        }
        return sum;
    }

    public int used() {
        int count = 0;
        for (Entry each : this.entries()) {
            if (each.value == 0.0) continue;
            ++count;
        }
        return count;
    }

    public static Vector from(double ... values) {
        return new DenseVector((double[])values.clone());
    }

    public static Vector copy(double[] values, int start, int length) {
        return new DenseVector(Arrays.copyOfRange(values, start, start + length));
    }

    public static Vector wrap(double ... values) {
        return new DenseVector(values);
    }

    public static Vector dense(int size) {
        return new DenseVector(size);
    }

    public static Vector sparse(int size) {
        return new SparseVector(size);
    }

    public double dot(Vector x) {
        double product = 0.0;
        for (Entry each : this.entries()) {
            product += each.value * x.get(each.index);
        }
        return product;
    }

    public void scaleAndAddTo(double a, Vector y) {
        for (Entry each : this.entries()) {
            y.add(each.index, a * each.value);
        }
    }

    public void storeOn(double[] array, int start) {
        assert (start + this.size() <= array.length);
        Arrays.fill(array, start, start + this.size(), 0.0);
        for (Entry each : this.entries()) {
            array[start + each.index] = each.value;
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        out.append("(");
        for (Entry each : this.entries()) {
            out.append(each.value + ", ");
        }
        out.append(")");
        return out.toString();
    }

    public abstract Vector times(double var1);

    public abstract Vector timesEquals(double var1);

    public abstract boolean equals(Vector var1, double var2);

    public double[] unwrap() {
        throw new Error("cannot unwrap instance of " + this.getClass());
    }

    public void applyCentering() {
        double[] values = this.unwrap();
        double mean = Util.sum(values) / (double)values.length;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] - mean;
        }
    }

    public double mean() {
        double[] values = this.unwrap();
        return Util.sum(values) / (double)values.length;
    }

    public final class Entry {
        public final int index;
        public final double value;

        public Entry(int index, double value) {
            this.index = index;
            this.value = value;
        }
    }
}

