/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.Vector;

public class DenseVector
extends Vector {
    private double unit = 0.0;
    double[] values;

    protected DenseVector(double[] values) {
        this.values = values;
    }

    protected DenseVector(int size) {
        this.values = new double[size];
    }

    public double cosine(DenseVector other) {
        assert (other.size() == this.size());
        double sum = 0.0;
        for (int n = 0; n < this.values.length; ++n) {
            sum += this.values[n] * other.values[n];
        }
        return sum / (this.norm() * other.norm());
    }

    @Override
    public double get(int index) {
        return this.values[index];
    }

    @Override
    public double norm() {
        if (this.unit != 0.0) {
            return this.unit;
        }
        double qsum = 0.0;
        for (double value : this.values) {
            qsum += value * value;
        }
        if (qsum == 0.0) {
            qsum = 1.0;
        }
        this.unit = Math.sqrt(qsum);
        return this.unit;
    }

    @Override
    public double put(int index, double value) {
        this.values[index] = value;
        return this.values[index];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Vector times(double scalar) {
        double[] times = new double[this.values.length];
        for (int n = 0; n < this.values.length; ++n) {
            times[n] = this.values[n] * scalar;
        }
        return new DenseVector(times);
    }

    @Override
    public Vector timesEquals(double scalar) {
        int n = 0;
        while (n < this.values.length) {
            int n2 = n++;
            this.values[n2] = this.values[n2] * scalar;
        }
        return this;
    }

    @Override
    public boolean equals(Vector v, double epsilon) {
        if (this.size() != v.size()) {
            return false;
        }
        assert (v instanceof DenseVector);
        DenseVector d = (DenseVector)v;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] - d.values[i] > epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] unwrap() {
        return this.values;
    }
}

