/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile.combine;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class CombineSequenceFileRecordReader<K, V>
extends RecordReader<K, V> {
    private CombineFileSplit split;
    private TaskAttemptContext context;
    private int index;
    private RecordReader<K, V> rr;

    public CombineSequenceFileRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer index) throws IOException, InterruptedException {
        this.index = index;
        this.split = split;
        this.context = context;
        this.rr = (RecordReader)ReflectionUtils.newInstance(SequenceFileRecordReader.class, (Configuration)context.getConfiguration());
    }

    public void initialize(InputSplit curSplit, TaskAttemptContext curContext) throws IOException, InterruptedException {
        this.split = (CombineFileSplit)curSplit;
        this.context = curContext;
        if (null == this.rr) {
            this.rr = (RecordReader)ReflectionUtils.newInstance(SequenceFileRecordReader.class, (Configuration)this.context.getConfiguration());
        }
        FileSplit fileSplit = new FileSplit(this.split.getPath(this.index), this.split.getOffset(this.index), this.split.getLength(this.index), this.split.getLocations());
        this.rr.initialize((InputSplit)fileSplit, this.context);
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.rr.getProgress();
    }

    public void close() throws IOException {
        if (null != this.rr) {
            this.rr.close();
            this.rr = null;
        }
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)this.rr.getCurrentKey();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)this.rr.getCurrentValue();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rr.nextKeyValue();
    }
}

