/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.util.List;
import org.apache.hadoop.io.BytesWritable;
import org.openimaj.hadoop.sequencefile.ExtractionState;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier;

public enum NamingStrategy {
    KEY{

        @Override
        public <K, V> String getNameInternal(K key, V value, ExtractionState state) {
            return key.toString();
        }
    }
    ,
    NUMERICAL{

        @Override
        public <K, V> String getNameInternal(K key, V value, ExtractionState state) {
            return "" + state.getCount();
        }
    };


    protected abstract <K, V> String getNameInternal(K var1, V var2, ExtractionState var3);

    public <K, V> String getName(K key, V value, ExtractionState state, boolean addExtension) {
        String mime;
        MagicMimeTypeIdentifier match;
        List exts;
        String name = this.getNameInternal(key, value, state);
        if (addExtension && value instanceof BytesWritable && (exts = (match = new MagicMimeTypeIdentifier()).getExtensionsFor(mime = match.identify(((BytesWritable)value).getBytes(), key.toString(), null))).size() > 0) {
            name = name + "." + (String)exts.get(0);
        }
        return name;
    }
}

