/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;

public class MetadataConfiguration {
    private static final String META_PREFIX = "org.openimaj.hadoop.sequencefile.metadata.";
    private static final String META_KEYS = "org.openimaj.hadoop.sequencefile.metadata.__metadataKeys__";
    public static final String UUID_KEY = "UUID";
    public static final String COMMENT_KEY = "Comment";
    public static final String CONTENT_TYPE_KEY = "ContentType";

    private MetadataConfiguration() {
    }

    public static SequenceFile.Metadata getMetadata(Configuration conf) {
        SequenceFile.Metadata metadata = new SequenceFile.Metadata();
        String[] keys = conf.getStrings(META_KEYS);
        if (keys != null) {
            for (String key : keys) {
                String value = conf.get(META_PREFIX + key);
                if (value == null) continue;
                metadata.set(new Text(key), new Text(value));
            }
        }
        return metadata;
    }

    public static void setMetadata(Map<String, String> metadata, Configuration conf) {
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            conf.set(META_PREFIX + entry.getKey(), entry.getValue());
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (conf.getStringCollection(META_KEYS) != null) {
            keys.addAll(conf.getStringCollection(META_KEYS));
        }
        for (String key : metadata.keySet()) {
            keys.add(key);
        }
        conf.setStrings(META_KEYS, keys.toArray(new String[keys.size()]));
    }
}

