/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.mapreduce.stage;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.openimaj.hadoop.mapreduce.stage.IdentityMapper;
import org.openimaj.hadoop.mapreduce.stage.IdentityReducer;
import org.openimaj.util.reflection.ReflectionUtils;

public abstract class Stage<INPUT_FORMAT extends FileInputFormat<INPUT_KEY, INPUT_VALUE>, OUTPUT_FORMAT extends FileOutputFormat<OUTPUT_KEY, OUTPUT_VALUE>, INPUT_KEY, INPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE> {
    private Class<INPUT_FORMAT> inputFormatClass;
    private Class<OUTPUT_FORMAT> outputFormatClass;
    private Class<INPUT_VALUE> inputValueClass;
    private Class<INPUT_KEY> inputKeyClass;
    private Class<MAP_OUTPUT_KEY> mapOutputKeyClass;
    private Class<MAP_OUTPUT_VALUE> mapOutputValueClass;
    private Class<OUTPUT_KEY> outputKeyClass;
    private Class<OUTPUT_VALUE> outputValueClass;
    private List<Class<?>> genericTypes = ReflectionUtils.getTypeArguments(Stage.class, this.getClass());

    public Stage() {
        this.inputFormatClass = this.genericTypes.get(0);
        this.outputFormatClass = this.genericTypes.get(1);
        this.inputKeyClass = this.genericTypes.get(2);
        this.inputValueClass = this.genericTypes.get(3);
        this.mapOutputKeyClass = this.genericTypes.get(4);
        this.mapOutputValueClass = this.genericTypes.get(5);
        this.outputKeyClass = this.genericTypes.get(6);
        this.outputValueClass = this.genericTypes.get(7);
    }

    public String outname() {
        return null;
    }

    public Job stage(Path[] inputs, Path output, Configuration conf) throws Exception {
        Job job = new Job(conf);
        if (this.inputFormatClass.equals(TextInputFormat.class) && this.containsLZO(inputs)) {
            job.setInputFormatClass(Class.forName("com.hadoop.mapreduce.LzoTextInputFormat"));
        } else {
            job.setInputFormatClass(this.inputFormatClass);
        }
        job.setMapOutputKeyClass(this.mapOutputKeyClass);
        job.setMapOutputValueClass(this.mapOutputValueClass);
        job.setOutputKeyClass(this.outputKeyClass);
        job.setOutputValueClass(this.outputValueClass);
        job.setOutputFormatClass(this.outputFormatClass);
        if (this.outputFormatClass.equals(TextOutputFormat.class) && this.lzoCompress()) {
            TextOutputFormat.setCompressOutput((Job)job, (boolean)true);
            TextOutputFormat.setOutputCompressorClass((Job)job, Class.forName("com.hadoop.compression.lzo.LzopCodec"));
        } else {
            TextOutputFormat.setCompressOutput((Job)job, (boolean)false);
        }
        job.setJarByClass(this.getClass());
        this.setInputPaths(job, inputs);
        this.setOutputPath(job, output);
        this.setMapperClass(job, this.mapper());
        this.setReducerClass(job, this.reducer());
        this.setCombinerClass(job, this.combiner());
        this.setup(job);
        return job;
    }

    public void setCombinerClass(Job job, Class<? extends Reducer<MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE>> combiner) {
        job.setCombinerClass(combiner);
    }

    public void setReducerClass(Job job, Class<? extends Reducer<MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE>> reducer) {
        job.setReducerClass(reducer);
    }

    public void setMapperClass(Job job, Class<? extends Mapper<INPUT_KEY, INPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE>> mapper) {
        job.setMapperClass(mapper);
    }

    private boolean containsLZO(Path[] inputs) {
        for (Path path : inputs) {
            if (!path.getName().endsWith(".lzo")) continue;
            return true;
        }
        return false;
    }

    public void setup(Job job) throws IOException {
    }

    public Class<? extends Mapper<INPUT_KEY, INPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE>> mapper() {
        IdentityMapper nr = new IdentityMapper();
        return ((Object)((Object)nr)).getClass();
    }

    public Class<? extends Reducer<MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE>> reducer() {
        IdentityReducer nr = new IdentityReducer();
        return ((Object)((Object)nr)).getClass();
    }

    public Class<? extends Reducer<MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE>> combiner() {
        IdentityReducer nr = new IdentityReducer();
        return ((Object)((Object)nr)).getClass();
    }

    private void setOutputPath(Job job, Path output) {
        try {
            Method method = this.outputFormatClass.getMethod("setOutputPath", Job.class, Path.class);
            method.invoke(null, job, output);
        }
        catch (Exception e) {
            System.err.println("Couldn't set output path!");
        }
    }

    private void setInputPaths(Job job, Path[] inputs) {
        try {
            Method method = this.inputFormatClass.getMethod("setInputPaths", Job.class, Path[].class);
            method.invoke(null, job, inputs);
        }
        catch (Exception e) {
            System.err.println("Couldn't set input path!");
        }
    }

    public void finished(Job job) {
    }

    public boolean lzoCompress() {
        return false;
    }
}

