/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DecompressorStream
extends CompressionInputStream {
    private static final int MAX_INPUT_BUFFER_SIZE = 512;
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private byte[] skipBytes;
    private byte[] oneByte = new byte[1];
    protected Decompressor decompressor = null;
    protected byte[] buffer;
    protected boolean eof = false;
    protected boolean closed = false;
    private int lastBytesSent = 0;

    @VisibleForTesting
    DecompressorStream(InputStream in, Decompressor decompressor, int bufferSize, int skipBufferSize) throws IOException {
        super(in);
        if (in == null || decompressor == null) {
            throw new NullPointerException();
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Illegal bufferSize");
        }
        this.decompressor = decompressor;
        this.buffer = new byte[bufferSize];
        this.skipBytes = new byte[skipBufferSize];
    }

    public DecompressorStream(InputStream in, Decompressor decompressor, int bufferSize) throws IOException {
        this(in, decompressor, bufferSize, 2048);
    }

    public DecompressorStream(InputStream in, Decompressor decompressor) throws IOException {
        this(in, decompressor, 512);
    }

    protected DecompressorStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    public int read() throws IOException {
        this.checkStream();
        return this.read(this.oneByte, 0, this.oneByte.length) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.decompress(b, off, len);
    }

    protected int decompress(byte[] b, int off, int len) throws IOException {
        int n;
        while ((n = this.decompressor.decompress(b, off, len)) == 0) {
            if (this.decompressor.needsDictionary()) {
                this.eof = true;
                return -1;
            }
            if (this.decompressor.finished()) {
                int nRemaining = this.decompressor.getRemaining();
                if (nRemaining == 0) {
                    int m = this.getCompressedData();
                    if (m == -1) {
                        this.eof = true;
                        return -1;
                    }
                    this.decompressor.reset();
                    this.decompressor.setInput(this.buffer, 0, m);
                    this.lastBytesSent = m;
                    continue;
                }
                this.decompressor.reset();
                int leftoverOffset = this.lastBytesSent - nRemaining;
                assert (leftoverOffset >= 0);
                this.decompressor.setInput(this.buffer, leftoverOffset, nRemaining);
                continue;
            }
            if (!this.decompressor.needsInput()) continue;
            int m = this.getCompressedData();
            if (m == -1) {
                throw new EOFException("Unexpected end of input stream");
            }
            this.decompressor.setInput(this.buffer, 0, m);
            this.lastBytesSent = m;
        }
        return n;
    }

    protected int getCompressedData() throws IOException {
        this.checkStream();
        return this.in.read(this.buffer, 0, this.buffer.length);
    }

    protected void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void resetState() throws IOException {
        this.decompressor.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.checkStream();
        int skipped = 0;
        while ((long)skipped < n) {
            int len = Math.min((int)n - skipped, this.skipBytes.length);
            if ((len = this.read(this.skipBytes, 0, len)) == -1) {
                this.eof = true;
                break;
            }
            skipped += len;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.checkStream();
        return this.eof ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                super.close();
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

