/*
 * Decompiled with CFR 0.152.
 */
package uk.co.magus.fourstore.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;

public class Store {
    private URL baseURL;
    private URL statusURL;
    private URL sizeURL;
    private URL dataURL;
    private URL sparqlURL;
    private URL updateURL;

    public Store(String u) throws MalformedURLException {
        this.baseURL = new URL(u);
        this.init();
    }

    public Store(URL u) throws MalformedURLException {
        this.baseURL = u;
        this.init();
    }

    private void init() throws MalformedURLException {
        this.statusURL = new URL(this.baseURL + "/status");
        this.sizeURL = new URL(this.statusURL + "/size/");
        this.dataURL = new URL(this.baseURL + "/data/");
        this.sparqlURL = new URL(this.baseURL + "/sparql/");
        this.updateURL = new URL(this.baseURL + "/update/");
    }

    public String getSize() throws IOException {
        return this.readResponse(this.sizeURL);
    }

    public String getStatus() throws IOException {
        return this.readResponse(this.statusURL);
    }

    public String append(String graphData, InputFormat format) throws MalformedURLException, ProtocolException, IOException {
        return this.append("", graphData, format);
    }

    public String append(String graphName, String graphData, InputFormat format) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)this.dataURL.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream ps = new DataOutputStream(connection.getOutputStream());
        ps.writeBytes("mime-type=" + format.getMimeType() + "&graph=" + URLEncoder.encode(graphName, "UTF-8") + "&data=" + URLEncoder.encode(graphData, "UTF-8"));
        ps.flush();
        ps.close();
        return this.readResponse(connection);
    }

    public String delete(String graph) throws MalformedURLException, ProtocolException, IOException {
        URL deleteURL = new URL(this.dataURL + URLEncoder.encode(graph, "UTF-8"));
        HttpURLConnection connection = (HttpURLConnection)deleteURL.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("DELETE");
        return this.readResponse(connection);
    }

    public String add(String graphName, String graphData, InputFormat format) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.dataURL + graphName).openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", format.getMimeType());
        DataOutputStream ps = new DataOutputStream(connection.getOutputStream());
        ps.writeBytes(graphData);
        ps.flush();
        ps.close();
        return this.readResponse(connection);
    }

    public String query(String sparql) throws MalformedURLException, ProtocolException, IOException {
        return this.query(sparql, OutputFormat.SPARQL_XML, Integer.MIN_VALUE);
    }

    public String query(String sparql, int softLimit) throws MalformedURLException, ProtocolException, IOException {
        return this.query(sparql, OutputFormat.SPARQL_XML, softLimit);
    }

    public String query(String sparql, OutputFormat format) throws MalformedURLException, ProtocolException, IOException {
        return this.query(sparql, format, Integer.MIN_VALUE);
    }

    public String query(String sparql, OutputFormat format, int softLimit) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)this.sparqlURL.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Accept", format.getMimeType());
        DataOutputStream ps = new DataOutputStream(connection.getOutputStream());
        if (softLimit != Integer.MIN_VALUE) {
            ps.writeBytes("&query=" + URLEncoder.encode(sparql, "UTF-8") + "&soft-limit=" + softLimit);
        } else {
            ps.writeBytes("&query=" + URLEncoder.encode(sparql, "UTF-8"));
        }
        ps.flush();
        ps.close();
        return this.readResponse(connection);
    }

    private String readResponse(HttpURLConnection connection) throws MalformedURLException, ProtocolException, IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = "";
        while (null != (str = in.readLine())) {
            response = response + str + System.getProperty("line.separator");
        }
        in.close();
        return response;
    }

    private String readResponse(URL u) throws IOException {
        String response;
        BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
        while ((response = in.readLine()) != null) {
            System.out.println(response);
        }
        in.close();
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputFormat {
        TAB_SEPARATED("text/tab-separated-values"),
        JSON("application/sparql-results+json"),
        SPARQL_XML("application/sparql-results+xml");

        private final String mimeType;

        private OutputFormat(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputFormat {
        TURTLE("application/x-turtle"),
        XML("application/rdf+xml"),
        N3("text/rdf+n3"),
        NT("text/rdf+nt"),
        TriG("application/x-trig");

        private final String mimeType;

        private InputFormat(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

