/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.haar.Classifier;
import org.openimaj.image.objectdetection.haar.HaarFeature;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public class HaarFeatureClassifier
implements Classifier {
    Classifier left;
    Classifier right;
    HaarFeature feature;
    float threshold;

    public HaarFeatureClassifier(HaarFeature feature, float threshold, Classifier left, Classifier right) {
        this.feature = feature;
        this.threshold = threshold;
        this.left = left;
        this.right = right;
    }

    @Override
    public float classify(SummedSqTiltAreaTable sat, float wvNorm, int x, int y) {
        float response = this.feature.computeResponse(sat, x, y);
        return response < this.threshold * wvNorm ? this.left.classify(sat, wvNorm, x, y) : this.right.classify(sat, wvNorm, x, y);
    }

    @Override
    public void updateCaches(StageTreeClassifier cascade) {
        this.feature.updateCaches(cascade);
        this.left.updateCaches(cascade);
        this.right.updateCaches(cascade);
    }
}

