/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.filtering;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.objectdetection.filtering.DetectionFilter;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.ObjectIntPair;

public final class OpenCVGrouping
implements DetectionFilter<Rectangle, ObjectIntPair<Rectangle>> {
    public static final float DEFAULT_EPS = 0.2f;
    public static final int DEFAULT_MINIMUM_SUPPORT = 3;
    float eps;
    int minSupport;

    public OpenCVGrouping(float eps, int minSupport) {
        this.eps = eps;
        this.minSupport = minSupport;
    }

    public OpenCVGrouping(int minSupport) {
        this(0.2f, minSupport);
    }

    public OpenCVGrouping() {
        this(0.2f, 3);
    }

    @Override
    public List<ObjectIntPair<Rectangle>> apply(List<Rectangle> input) {
        int i;
        int[] classes = new int[input.size()];
        int nClasses = this.partition(input, classes);
        Rectangle[] meanRects = new Rectangle[nClasses];
        int[] rectCounts = new int[nClasses];
        for (i = 0; i < nClasses; ++i) {
            meanRects[i] = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        for (i = 0; i < classes.length; ++i) {
            int cls = classes[i];
            meanRects[cls].x += input.get((int)i).x;
            meanRects[cls].y += input.get((int)i).y;
            meanRects[cls].width += input.get((int)i).width;
            meanRects[cls].height += input.get((int)i).height;
            int n = cls;
            rectCounts[n] = rectCounts[n] + 1;
        }
        for (i = 0; i < nClasses; ++i) {
            Rectangle r = meanRects[i];
            float s = 1.0f / (float)rectCounts[i];
            meanRects[i] = new Rectangle((float)Math.round(r.x * s), (float)Math.round(r.y * s), (float)Math.round(r.width * s), (float)Math.round(r.height * s));
        }
        ArrayList<ObjectIntPair<Rectangle>> rectList = new ArrayList<ObjectIntPair<Rectangle>>();
        for (int i2 = 0; i2 < nClasses; ++i2) {
            int j;
            Rectangle r1 = meanRects[i2];
            int n1 = rectCounts[i2];
            if (n1 <= this.minSupport) continue;
            for (j = 0; j < nClasses; ++j) {
                int n2 = rectCounts[j];
                if (j == i2 || n2 <= this.minSupport) continue;
                Rectangle r2 = meanRects[j];
                int dx = Math.round(r2.width * this.eps);
                int dy = Math.round(r2.height * this.eps);
                if (i2 != j && r1.x >= r2.x - (float)dx && r1.y >= r2.y - (float)dy && r1.x + r1.width <= r2.x + r2.width + (float)dx && r1.y + r1.height <= r2.y + r2.height + (float)dy && (n2 > Math.max(3, n1) || n1 < 3)) break;
            }
            if (j != nClasses) continue;
            rectList.add((ObjectIntPair<Rectangle>)new ObjectIntPair((Object)r1, n1));
        }
        return rectList;
    }

    private int partition(List<Rectangle> rects, int[] classes) {
        int numClasses = 0;
        for (int i = 0; i < rects.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < i; ++j) {
                if (!this.equals(rects.get(j), rects.get(i))) continue;
                found = true;
                classes[i] = classes[j];
            }
            if (found) continue;
            classes[i] = numClasses++;
        }
        return numClasses;
    }

    private boolean equals(Rectangle r1, Rectangle r2) {
        float delta = this.eps * (Math.min(r1.width, r2.width) + Math.min(r1.height, r2.height)) * 0.5f;
        return Math.abs(r1.x - r2.x) <= delta && Math.abs(r1.y - r2.y) <= delta && Math.abs(r1.x + r1.width - r2.x - r2.width) <= delta && Math.abs(r1.y + r1.height - r2.y - r2.height) <= delta;
    }
}

