/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.util;

import Jama.Matrix;
import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.InputStream;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.face.detection.CLMDetectedFace;
import org.openimaj.image.processing.face.tracking.clm.MultiTracker;
import org.openimaj.image.processing.face.util.DetectedFaceRenderer;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.shape.Triangle;

public class CLMDetectedFaceRenderer
implements DetectedFaceRenderer<CLMDetectedFace> {
    private int[][] triangles;
    private boolean drawTriangles = true;
    private boolean drawConnections = true;
    private boolean drawPoints = true;
    private boolean drawBounds = true;
    private int[][] connections;
    private float scale = 1.0f;
    private Float[] boundingBoxColour = RGBColour.RED;
    private Float[] pointColour = RGBColour.BLUE;
    private Float[] meshColour = RGBColour.GREEN;
    private Float[] connectionColour = RGBColour.YELLOW;
    private int thickness;

    public CLMDetectedFaceRenderer() {
        this.triangles = IO.loadTri((InputStream)Tracker.class.getResourceAsStream("face.tri"));
        this.connections = IO.loadCon((InputStream)Tracker.class.getResourceAsStream("face.con"));
    }

    @Override
    public void drawDetectedFace(MBFImage image, int thickness, CLMDetectedFace f) {
        this.thickness = thickness;
        this.drawFaceModel(image, f.getShapeMatrix(), f.getVisibility(), f.getBounds());
    }

    public void drawDetectedFace(MBFImage image, MultiTracker.TrackedFace f) {
        this.drawFaceModel(image, f.shape, f.clm._visi[f.clm.getViewIdx()], f.lastMatchBounds);
    }

    private void drawFaceModel(MBFImage image, Matrix shape, Matrix visi, Rectangle bounds) {
        int i;
        int n = shape.getRowDimension() / 2;
        if (this.drawBounds && bounds != null) {
            image.createRenderer().drawShape((Shape)bounds, (Object)this.boundingBoxColour);
        }
        if (this.drawTriangles) {
            for (i = 0; i < this.triangles.length; ++i) {
                if (visi.get(this.triangles[i][0], 0) == 0.0 || visi.get(this.triangles[i][1], 0) == 0.0 || visi.get(this.triangles[i][2], 0) == 0.0) continue;
                Triangle t = new Triangle((Point2d)new Point2dImpl((float)(shape.get(this.triangles[i][0], 0) + (double)bounds.x) / this.scale, (float)(shape.get(this.triangles[i][0] + n, 0) + (double)bounds.y) / this.scale), (Point2d)new Point2dImpl((float)(shape.get(this.triangles[i][1], 0) + (double)bounds.x) / this.scale, (float)(shape.get(this.triangles[i][1] + n, 0) + (double)bounds.y) / this.scale), (Point2d)new Point2dImpl((float)(shape.get(this.triangles[i][2], 0) + (double)bounds.x) / this.scale, (float)(shape.get(this.triangles[i][2] + n, 0) + (double)bounds.y) / this.scale));
                image.drawShape((Shape)t, this.thickness, (Object)this.meshColour);
            }
        }
        if (this.drawConnections) {
            for (i = 0; i < this.connections[0].length; ++i) {
                if (visi.get(this.connections[0][i], 0) == 0.0 || visi.get(this.connections[1][i], 0) == 0.0) continue;
                image.drawLine((Point2d)new Point2dImpl((float)(shape.get(this.connections[0][i], 0) + (double)bounds.x) / this.scale, (float)(shape.get(this.connections[0][i] + n, 0) + (double)bounds.y) / this.scale), (Point2d)new Point2dImpl((float)(shape.get(this.connections[1][i], 0) + (double)bounds.x) / this.scale, (float)(shape.get(this.connections[1][i] + n, 0) + (double)bounds.y) / this.scale), this.thickness, (Object)this.connectionColour);
            }
        }
        if (this.drawPoints) {
            for (i = 0; i < n; ++i) {
                if (visi.get(i, 0) == 0.0) continue;
                image.drawPoint((Point2d)new Point2dImpl(((float)shape.get(i, 0) + bounds.x) / this.scale, ((float)shape.get(i + n, 0) + bounds.y) / this.scale), (Object)this.pointColour, this.thickness);
            }
        }
    }

    public static void render(MBFImage mbf, int thickness, CLMDetectedFace face) {
        CLMDetectedFaceRenderer render = new CLMDetectedFaceRenderer();
        render.drawDetectedFace(mbf, thickness, face);
    }
}

