/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition.benchmarking.dataset;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;

public class TextFileDataset
extends MapBackedDataset<String, ListDataset<FImage>, FImage> {
    private static final Logger logger = Logger.getLogger(TextFileDataset.class);
    private String separator = ",";
    File file;
    BufferedWriter writer;

    public TextFileDataset(File file) throws IOException {
        this(file, ",");
    }

    public TextFileDataset(File file, String separator) throws IOException {
        this.file = file;
        this.separator = separator;
        if (file.exists()) {
            this.read();
        } else {
            this.openWriter();
        }
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.file));
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(this.separator);
                this.addInternal(parts[0].trim(), new File(parts[1].trim()));
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addInternal(String person, File file) {
        ListBackedDataset list = (ListBackedDataset)this.map.get(person);
        if (list == null) {
            list = new ListBackedDataset((List)new LazyImageList());
            this.map.put(person, list);
        }
        ((LazyImageList)list.getList()).files.add(file);
    }

    public void add(String person, File file) throws IOException {
        if (this.writer == null) {
            this.openWriter();
        }
        this.writer.write(person + this.separator + file.getAbsolutePath() + "\n");
        this.writer.flush();
        this.addInternal(person, file);
    }

    private void openWriter() throws IOException {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.file, true));
        }
        catch (IOException e) {
            this.writer = null;
            throw e;
        }
    }

    public String toString() {
        return "Text File Dataset (" + this.file + ")";
    }

    private class LazyImageList
    extends AbstractList<FImage> {
        List<File> files = new ArrayList<File>();

        private LazyImageList() {
        }

        @Override
        public FImage get(int index) {
            File f = this.files.get(index);
            if (f.isAbsolute()) {
                try {
                    return ImageUtilities.readF((File)f);
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                    return null;
                }
            }
            try {
                return ImageUtilities.readF((File)new File(TextFileDataset.this.file.getParentFile(), f.toString()));
            }
            catch (IOException e) {
                logger.warn((Object)e);
                return null;
            }
        }

        @Override
        public int size() {
            return this.files.size();
        }

        @Override
        public String toString() {
            return this.files.toString();
        }
    }
}

