/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.benchmarking;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.math.combinatorics.optimisation.HungarianAlgorithm;
import org.openimaj.math.geometry.shape.Polygon;

public class Matcher {
    private double[][] computePairwiseScores(List<? extends DetectedFace> groundTruth, List<? extends DetectedFace> detected) {
        int numGround = groundTruth.size();
        int numDet = detected.size();
        double[][] scores = new double[numGround][numDet];
        for (int i = 0; i < numGround; ++i) {
            for (int j = 0; j < numDet; ++j) {
                scores[i][j] = this.computeScore(groundTruth.get(i), detected.get(j));
            }
        }
        return scores;
    }

    private double computeScore(DetectedFace ground, DetectedFace detected) {
        Polygon gs = ground.getShape().asPolygon();
        Polygon ds = detected.getShape().asPolygon();
        return gs.intersect(ds).calculateArea() / gs.union(ds).calculateArea();
    }

    public List<Match> match(List<? extends DetectedFace> groundTruth, List<? extends DetectedFace> detected) {
        double[][] scores = this.computePairwiseScores(groundTruth, detected);
        double[][] filtered = this.collapse(scores);
        if (filtered.length == 0 || filtered[0].length == 0) {
            return null;
        }
        HungarianAlgorithm ha = new HungarianAlgorithm(filtered);
        int[] assignments = ha.execute();
        ArrayList<Match> results = new ArrayList<Match>();
        for (int gtIdx = 0; gtIdx < assignments.length; ++gtIdx) {
            int detIdx;
            double score;
            if (assignments[gtIdx] < 0 || !((score = scores[gtIdx][detIdx = assignments[gtIdx]]) > 0.0)) continue;
            results.add(new Match(groundTruth.get(gtIdx), detected.get(detIdx), score));
        }
        return results;
    }

    private double[][] collapse(double[][] scores) {
        int c;
        TIntArrayList rowsToKeep = new TIntArrayList(scores[0].length);
        for (int r = 0; r < scores.length; ++r) {
            double sum = 0.0;
            for (c = 0; c < scores[0].length; ++c) {
                sum += scores[r][c];
            }
            if (sum == 0.0) continue;
            rowsToKeep.add(r);
        }
        TIntArrayList colsToKeep = new TIntArrayList(scores.length);
        for (int c2 = 0; c2 < scores[0].length; ++c2) {
            double sum = 0.0;
            for (int r = 0; r < scores.length; ++r) {
                sum += scores[r][c2];
            }
            if (sum == 0.0) continue;
            colsToKeep.add(c2);
        }
        if (rowsToKeep.size() == scores[0].length && colsToKeep.size() == scores.length) {
            return scores;
        }
        double[][] filtered = new double[rowsToKeep.size()][colsToKeep.size()];
        for (int r = 0; r < filtered.length; ++r) {
            for (c = 0; c < filtered[0].length; ++c) {
                filtered[r][c] = scores[rowsToKeep.get(r)][colsToKeep.get(c)];
            }
        }
        return filtered;
    }

    public static class Match {
        DetectedFace groundTruth;
        DetectedFace detected;
        double score;

        public Match(DetectedFace groundTruth, DetectedFace detected, double score) {
            this.groundTruth = groundTruth;
            this.detected = detected;
            this.score = score;
        }

        public String toString() {
            return String.format("%s->%s : %f", this.groundTruth, this.detected, this.score);
        }
    }
}

