/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class CCDetectedFace
extends DetectedFace {
    ConnectedComponent connectedComponent;

    public CCDetectedFace() {
    }

    public CCDetectedFace(Rectangle bounds, FImage patch, ConnectedComponent cc, float confidence) {
        super(bounds, patch, confidence);
        this.connectedComponent = cc;
    }

    public PixelSet getConnectedComponent() {
        return this.connectedComponent;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        this.connectedComponent.writeBinary(out);
    }

    @Override
    public byte[] binaryHeader() {
        return "CCDF".getBytes();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.connectedComponent.readBinary(in);
    }

    @Override
    public Shape getShape() {
        return this.connectedComponent.toPolygon();
    }
}

