/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.io.FileUtil;
import gov.sandia.cognition.io.ObjectSerializationHandler;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultPair;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectUtil {
    public static boolean equalsSafe(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static int hashCodeSafe(Object value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static <T extends CloneableSerializable> T cloneSafe(T object) {
        if (object == null) {
            return null;
        }
        return (T)object.clone();
    }

    public static <T> T cloneSmart(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CloneableSerializable) {
            return (T)ObjectUtil.cloneSafe((CloneableSerializable)object);
        }
        Class<?> clazz = object.getClass();
        Method cloneMethod = null;
        try {
            cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (cloneMethod != null) {
            try {
                Object clone = cloneMethod.invoke(object, new Object[0]);
                return (T)clone;
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return object;
    }

    public static <T> ArrayList<T> cloneSmartElementsAsArrayList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T value : collection) {
            result.add(ObjectUtil.cloneSmart(value));
        }
        return result;
    }

    public static <T> LinkedList<T> cloneSmartElementsAsLinkedList(Iterable<T> collection) {
        if (collection == null) {
            return null;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T value : collection) {
            result.add(ObjectUtil.cloneSmart(value));
        }
        return result;
    }

    public static <T> T[] cloneSmartArrayAndElements(T[] array) {
        if (array == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = ObjectUtil.cloneSmart(array[i]);
        }
        return result;
    }

    public static <T extends Serializable> T deepCopy(T object) {
        if (object == null) {
            return null;
        }
        try {
            byte[] bytes = ObjectSerializationHandler.convertToBytes(object);
            return (T)((Serializable)ObjectSerializationHandler.convertFromBytes(bytes));
        }
        catch (Exception ex) {
            Logger.getLogger(ObjectUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String inspector(Object o) {
        Object instantiatedObject = null;
        Class<?> c = null;
        if (o instanceof String) {
            try {
                String s = (String)o;
                c = Class.forName(s);
            }
            catch (Exception e) {
                return "Exception: " + e.toString();
            }
        } else if (o instanceof Class) {
            c = (Class<?>)o;
        } else {
            c = o.getClass();
            instantiatedObject = o;
        }
        StringBuilder retval = new StringBuilder();
        retval.append("Class " + c.getSimpleName() + " extends " + c.getSuperclass() + "\n");
        if (c.getInterfaces().length > 0) {
            retval.append("Implements " + c.getInterfaces().length + " interfaces:");
            for (Class<?> i : c.getInterfaces()) {
                retval.append(" " + i.getSimpleName());
            }
            retval.append("\n");
        }
        retval.append("------------- Methods ----------------\n");
        retval.append(ObjectUtil.inspectAPI(c));
        retval.append("------------- Fields ----------------\n");
        if (instantiatedObject == null) {
            retval.append(ObjectUtil.inspectFields(c));
        } else {
            retval.append(ObjectUtil.inspectFieldValues(instantiatedObject));
        }
        return retval.toString();
    }

    public static String inspectAPI(Class c) {
        Constructor<?>[] constructors;
        LinkedList<Method> methods = ObjectUtil.getMethods(c);
        StringBuilder retval = new StringBuilder();
        for (Constructor<?> m : constructors = c.getConstructors()) {
            retval.append(Modifier.toString(m.getModifiers()) + " ");
            retval.append(m.getName());
            retval.append("(");
            for (int j = 0; j < m.getParameterTypes().length; ++j) {
                retval.append(" " + m.getParameterTypes()[j].getSimpleName());
                if (j < m.getParameterTypes().length - 1) {
                    retval.append(",");
                    continue;
                }
                retval.append(" ");
            }
            retval.append(")");
            retval.append("\n");
        }
        for (Method m : methods) {
            retval.append(Modifier.toString(m.getModifiers()) + " ");
            retval.append(m.getReturnType().getSimpleName() + " ");
            retval.append(m.getName());
            retval.append("(");
            for (int j = 0; j < m.getParameterTypes().length; ++j) {
                retval.append(" " + m.getParameterTypes()[j].getSimpleName());
                if (j < m.getParameterTypes().length - 1) {
                    retval.append(",");
                    continue;
                }
                retval.append(" ");
            }
            retval.append(")");
            retval.append("\n");
        }
        return retval.toString();
    }

    public static LinkedList<Method> getMethods(Class c) {
        if (c == null || Object.class.equals((Object)c)) {
            return new LinkedList<Method>();
        }
        LinkedList<Method> methods = ObjectUtil.getMethods(c.getSuperclass());
        boolean isInterface = c.isInterface();
        for (Method m : c.getDeclaredMethods()) {
            if (!isInterface && Modifier.isVolatile(m.getModifiers())) continue;
            methods.add(m);
        }
        return methods;
    }

    public static String toString(Object o) {
        String retval;
        try {
            if (o.getClass().isArray()) {
                int num = Array.getLength(o);
                StringBuilder buffer = new StringBuilder(num * 20);
                buffer.append(o.getClass().getSimpleName() + " with " + num + " entries:\n");
                for (int i = 0; i < num; ++i) {
                    buffer.append("Index " + i + ":\n" + ObjectUtil.toString(Array.get(o, i)));
                }
                retval = buffer.toString();
            } else if (o instanceof Iterable) {
                Iterable iterable = (Iterable)o;
                int num = CollectionUtil.size(iterable);
                StringBuilder buffer = new StringBuilder(num * 20);
                buffer.append(o.getClass().getSimpleName() + " with " + num + " entries:\n");
                int index = 0;
                for (Object i : iterable) {
                    buffer.append("Index " + index + ":\n" + ObjectUtil.toString(i));
                    ++index;
                }
                retval = buffer.toString();
            } else {
                retval = o.getClass().getSimpleName() + " field values:\n" + ObjectUtil.inspectFieldValues(o);
            }
        }
        catch (Exception e) {
            retval = o.toString();
        }
        return retval;
    }

    public static String inspectFieldValues(Object o) {
        ArrayList<DefaultPair<Field, Object>> fieldValuePairs = ObjectUtil.getAllFieldValues(o);
        StringBuilder retval = new StringBuilder(fieldValuePairs.size() * 50);
        for (DefaultPair<Field, Object> fieldValuePair : fieldValuePairs) {
            Field f = fieldValuePair.getFirst();
            if (Modifier.isStatic(f.getModifiers())) continue;
            retval.append(f.getType().getSimpleName() + " ");
            retval.append(f.getName());
            Object v = fieldValuePair.getSecond();
            if (v != null) {
                retval.append(" = " + v.toString());
            } else {
                retval.append(" = {null or value protected}");
            }
            retval.append("\n");
        }
        return retval.toString();
    }

    public static String inspectFields(Class c) {
        StringBuilder retval = new StringBuilder();
        for (Field f : ObjectUtil.getAllFields(c)) {
            retval.append(Modifier.toString(f.getModifiers()) + " ");
            retval.append(f.getType().getSimpleName() + " ");
            retval.append(f.getName());
            retval.append("\n");
        }
        return retval.toString();
    }

    public static LinkedList<Field> getAllFields(Class c) {
        if (c == null || Object.class.equals((Object)c)) {
            return new LinkedList<Field>();
        }
        LinkedList<Field> fields = ObjectUtil.getAllFields(c.getSuperclass());
        fields.addAll(Arrays.asList(c.getDeclaredFields()));
        return fields;
    }

    public static ArrayList<DefaultPair<Field, Object>> getAllFieldValues(Object o) {
        LinkedList<Field> fields = ObjectUtil.getAllFields(o.getClass());
        ArrayList<Object> values = ObjectUtil.getFieldValues(o, fields);
        return DefaultPair.mergeCollections(fields, values);
    }

    public static ArrayList<Object> getFieldValues(Object o, Collection<Field> fields) {
        ArrayList<Object> retval = new ArrayList<Object>(fields.size());
        for (Field f : fields) {
            Object value;
            try {
                f.setAccessible(true);
                value = f.get(o);
            }
            catch (Exception e) {
                value = null;
            }
            retval.add(value);
        }
        return retval;
    }

    public static String getShortClassName(Object o) {
        return ObjectUtil.getShortClassName(o.getClass());
    }

    public static String getShortClassName(Class c) {
        return FileUtil.getExtension(c.toString());
    }

    public static byte[] getBytes(Object o) {
        try {
            return ObjectSerializationHandler.convertToBytes((Serializable)o);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

