/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.signals;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@PublicationReference(author={"Wikipedia"}, title="Fast Fourier transform", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Fast_Fourier_transform")
public class FourierTransform
extends AbstractCloneableSerializable
implements Evaluator<Collection<Double>, Collection<ComplexNumber>> {
    protected static ArrayList<ComplexNumber> convertToComplex(Collection<Double> data) {
        ArrayList<ComplexNumber> complexData = new ArrayList<ComplexNumber>(data.size());
        for (Double real : data) {
            complexData.add(new ComplexNumber(real, 0.0));
        }
        return complexData;
    }

    public static ComplexNumber[] discreteFourierTransform(ArrayList<Double> data) {
        return FourierTransform.discreteFourierTransformComplex(FourierTransform.convertToComplex(data));
    }

    @PublicationReference(author={"Wikipedia"}, title="Discrete Fourier transform", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Discrete_Fourier_transform")
    protected static ComplexNumber[] discreteFourierTransformComplex(ArrayList<ComplexNumber> data) {
        int num = data.size();
        ComplexNumber[] coefficients = new ComplexNumber[num];
        for (int k = 0; k < num; ++k) {
            ComplexNumber Xk = new ComplexNumber();
            double phi0 = Math.PI * -2 * (double)k / (double)num;
            for (int n = 0; n < num; ++n) {
                double phin = phi0 * (double)n;
                ComplexNumber wn = new ComplexNumber(Math.cos(phin), Math.sin(phin));
                wn.timesEquals(data.get(n));
                Xk.plusEquals(wn);
            }
            coefficients[k] = Xk;
        }
        return coefficients;
    }

    @PublicationReferences(references={@PublicationReference(author={"Wikipedia"}, title="Cooley-Tukey FFT algorithm", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Cooley-Tukey_FFT_algorithm"), @PublicationReference(author={"Robert Sedgewick", "Kevin Wayne"}, title="FFT.java", type=PublicationType.WebPage, year=2007, url="http://www.cs.princeton.edu/introcs/97data/FFT.java.html")})
    protected static ComplexNumber[] cooleyTukeyFFT(ArrayList<ComplexNumber> data) {
        int num = data.size();
        if (num == 1) {
            return new ComplexNumber[]{new ComplexNumber(data.get(0))};
        }
        if (num % 2 != 0) {
            return FourierTransform.discreteFourierTransformComplex(data);
        }
        int halfNum = num / 2;
        ArrayList<ComplexNumber> subset = new ArrayList<ComplexNumber>(halfNum);
        for (int i = 0; i < num; i += 2) {
            subset.add(data.get(i));
        }
        ComplexNumber[] evenCoefficients = FourierTransform.cooleyTukeyFFT(subset);
        subset.clear();
        for (int i = 1; i < num; i += 2) {
            subset.add(data.get(i));
        }
        ComplexNumber[] oddCoefficients = FourierTransform.cooleyTukeyFFT(subset);
        subset = null;
        ComplexNumber[] Y = new ComplexNumber[num];
        double v0 = Math.PI * -2 / (double)num;
        double vi = 0.0;
        for (int i = 0; i < halfNum; ++i) {
            ComplexNumber wi = new ComplexNumber(Math.cos(vi), Math.sin(vi));
            ComplexNumber wioddi = wi.times(oddCoefficients[i]);
            ComplexNumber eveni = evenCoefficients[i];
            Y[i] = eveni.plus(wioddi);
            Y[i + halfNum] = eveni.minus(wioddi);
            vi += v0;
        }
        return Y;
    }

    @Override
    public List<ComplexNumber> evaluate(Collection<Double> data) {
        ComplexNumber[] c = FourierTransform.cooleyTukeyFFT(FourierTransform.convertToComplex(data));
        List<ComplexNumber> coefficients = Arrays.asList(c);
        return coefficients;
    }

    public static ArrayList<Double> inverse(Collection<ComplexNumber> transformCoefficients) {
        int num = transformCoefficients.size();
        ArrayList<ComplexNumber> transformCoefficientsConjugate = new ArrayList<ComplexNumber>(num);
        for (ComplexNumber value : transformCoefficients) {
            transformCoefficientsConjugate.add(value.conjugate());
        }
        ComplexNumber[] complexData = FourierTransform.cooleyTukeyFFT(transformCoefficientsConjugate);
        ArrayList<Double> data = new ArrayList<Double>(num);
        double scale = 1.0 / (double)num;
        for (int i = 0; i < num; ++i) {
            data.add(complexData[i].getRealPart() * scale);
        }
        return data;
    }

    public static class Inverse
    extends AbstractCloneableSerializable
    implements Evaluator<Collection<ComplexNumber>, Collection<Double>> {
        @Override
        public ArrayList<Double> evaluate(Collection<ComplexNumber> input) {
            return FourierTransform.inverse(input);
        }
    }
}

