/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.annotation.SoftwareLicenseType;
import gov.sandia.cognition.annotation.SoftwareReference;
import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.AbstractMatrix;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.TwoMatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.math.matrix.mtj.MatrixUnionIteratorMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.EigenDecompositionRightMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.SingularValueDecompositionMTJ;
import java.util.Iterator;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.QR;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-18", changesNeeded=true, comments={"Comments marked throughout the file with / / / on first column."}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2006-05-18", moreChangesNeeded=false, comments={"Added an assertion to dotTimesEquals", "Commented the private classes so that they're up to snuff."})})
@PublicationReference(author={"Bjorn-Ove Heimsund"}, title="Matrix Toolkits for Java (MTJ)", type=PublicationType.WebPage, year=2006, url="http://ressim.berlios.de/", notes={"All subclasses essentially wrap one of MTJ's matrix classes."})
@SoftwareReference(name="Matrix Toolkits for Java (MTJ)", version="0.9.6", url="http://ressim.berlios.de/", license=SoftwareLicenseType.LGPL, licenseVersion="2.1", licenseURL="http://ressim.berlios.de/")
public abstract class AbstractMTJMatrix
extends AbstractMatrix {
    private transient no.uib.cipr.matrix.Matrix internalMatrix;

    protected AbstractMTJMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        this.setInternalMatrix(internalMatrix);
    }

    @Override
    public AbstractMTJMatrix clone() {
        AbstractMTJMatrix clone = (AbstractMTJMatrix)super.clone();
        clone.setInternalMatrix(this.getInternalMatrix().copy());
        return clone;
    }

    public no.uib.cipr.matrix.Matrix getInternalMatrix() {
        return this.internalMatrix;
    }

    protected void setInternalMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        if (internalMatrix == null) {
            throw new IllegalArgumentException("internalMatrix cannot be null!");
        }
        this.internalMatrix = internalMatrix;
    }

    @Override
    public int getNumRows() {
        return this.internalMatrix.numRows();
    }

    @Override
    public int getNumColumns() {
        return this.internalMatrix.numColumns();
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        return this.internalMatrix.get(rowIndex, columnIndex);
    }

    @Override
    public void setElement(int rowIndex, int columnIndex, double value) {
        this.internalMatrix.set(rowIndex, columnIndex, value);
    }

    @Override
    public ComplexNumber logDeterminant() {
        int sign;
        UpperTriangDenseMatrix triangularMatrix;
        QR decomposition;
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        DenseMatrix decompositionMatrix = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean useEVD = false;
        if (useEVD) {
            EigenDecompositionRightMTJ evd = EigenDecompositionRightMTJ.create(decompositionMatrix);
            return evd.getLogDeterminant();
        }
        boolean useQR = false;
        if (useQR) {
            decomposition = QR.factorize((no.uib.cipr.matrix.Matrix)this.internalMatrix);
            triangularMatrix = decomposition.getR();
            sign = 1;
        } else {
            decomposition = DenseLU.factorize((no.uib.cipr.matrix.Matrix)this.internalMatrix);
            triangularMatrix = decomposition.getU();
            sign = 1;
            for (int i = 0; i < decomposition.getPivots().length; ++i) {
                if (decomposition.getPivots()[i] == i + 1) continue;
                sign = -sign;
            }
        }
        int M = triangularMatrix.numRows();
        int N = triangularMatrix.numColumns();
        int maxIndex = M < N ? M : N;
        double logsum = 0.0;
        for (int i = 0; i < maxIndex; ++i) {
            double eigenvalue = triangularMatrix.get(i, i);
            if (eigenvalue < 0.0) {
                sign = -sign;
                logsum += Math.log(-eigenvalue);
                continue;
            }
            logsum += Math.log(eigenvalue);
        }
        return new ComplexNumber(logsum, sign < 0 ? Math.PI : 0.0);
    }

    @Override
    public boolean equals(AbstractMTJMatrix matrix, double effectiveZero) {
        MatrixUnionIteratorMTJ iterator = new MatrixUnionIteratorMTJ(this, matrix);
        while (iterator.hasNext()) {
            TwoMatrixEntry entry = iterator.next();
            double diff = entry.getFirstValue() - entry.getSecondValue();
            if (!(Math.abs(diff) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plusEquals(Matrix matrix) {
        this.plusEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void plusEquals(AbstractMTJMatrix matrix) {
        this.internalMatrix.add(matrix.internalMatrix);
    }

    @Override
    public void minusEquals(Matrix matrix) {
        this.minusEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void minusEquals(AbstractMTJMatrix matrix) {
        double additionScaleFactor = -1.0;
        this.internalMatrix.add(additionScaleFactor, matrix.internalMatrix);
    }

    @Override
    public AbstractMTJMatrix times(Matrix matrix) {
        return this.times((AbstractMTJMatrix)matrix);
    }

    public abstract AbstractMTJMatrix times(AbstractMTJMatrix var1);

    @Override
    public void dotTimesEquals(Matrix matrix) {
        this.dotTimesEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void dotTimesEquals(AbstractMTJMatrix matrix) {
        this.assertSameDimensions(matrix);
        for (MatrixEntry e : this) {
            double otherValue = matrix.getElement(e.getRowIndex(), e.getColumnIndex());
            e.setValue(e.getValue() * otherValue);
        }
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        for (MatrixEntry e : this) {
            e.setValue(e.getValue() * scaleFactor);
        }
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new AbstractMTJMatrixIterator();
    }

    @Override
    public boolean isSquare() {
        return this.getNumRows() == this.getNumColumns();
    }

    @Override
    public AbstractMTJVector times(Vector vector) {
        return this.times((AbstractMTJVector)vector);
    }

    public abstract AbstractMTJVector times(AbstractMTJVector var1);

    @Override
    public void identity() {
        this.internalMatrix.zero();
        int N = this.getNumRows() < this.getNumColumns() ? this.getNumRows() : this.getNumColumns();
        for (int i = 0; i < N; ++i) {
            this.setElement(i, i, 1.0);
        }
    }

    @Override
    public Matrix solve(Matrix B) {
        return this.solve((AbstractMTJMatrix)B);
    }

    @Override
    public Vector solve(Vector b) {
        return this.solve((AbstractMTJVector)b);
    }

    public final Matrix solve(AbstractMTJMatrix B) {
        DenseMatrix X = new DenseMatrix(this.getNumColumns(), B.getNumColumns());
        DenseMatrix Bdense = B instanceof DenseMatrix ? (DenseMatrix)B : new DenseMatrix(B);
        DenseMatrix Adense = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean usePseudoInverse = false;
        try {
            Adense.solveInto(Bdense, X);
            usePseudoInverse = false;
        }
        catch (MatrixSingularException e) {
            System.out.println("Warning: AbstractMTJMatrix.solve(): Matrix is singular.");
            usePseudoInverse = true;
        }
        if (!usePseudoInverse) {
            for (int i = 0; i < X.getNumRows(); ++i) {
                for (int j = 0; j < X.getNumColumns(); ++j) {
                    double v = X.getElement(i, j);
                    if (!Double.isNaN(v) && !Double.isInfinite(v)) continue;
                    System.out.println("Warning: AbstractMTJMatrix.solve(): Solver produced invalid results.");
                    usePseudoInverse = true;
                    break;
                }
                if (usePseudoInverse) break;
            }
        }
        if (usePseudoInverse) {
            return Adense.pseudoInverse().times(Bdense);
        }
        return X;
    }

    public Vector solve(AbstractMTJVector b) {
        DenseVector x = new DenseVector(this.getNumColumns());
        DenseVector bdense = b instanceof DenseVector ? (DenseVector)b : new DenseVector(b);
        DenseMatrix Adense = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean usePseudoInverse = false;
        try {
            Adense.solveInto(bdense, x);
            usePseudoInverse = false;
        }
        catch (MatrixSingularException e) {
            System.out.println("Warning: AbstractMTJMatrix.solve(): Matrix is singular.");
            usePseudoInverse = true;
        }
        if (!usePseudoInverse) {
            for (int i = 0; i < x.getDimensionality(); ++i) {
                double v = x.getElement(i);
                if (!Double.isNaN(v) && !Double.isInfinite(v)) continue;
                System.out.println("Warning: AbstractMTJMatrix.solve(): Solver produced invalid results.");
                usePseudoInverse = true;
                break;
            }
        }
        if (usePseudoInverse) {
            return Adense.pseudoInverse().times(b);
        }
        return x;
    }

    @Override
    public Matrix inverse() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Can only invert square matrices.");
        }
        DenseMatrix I = (DenseMatrix)DenseMatrixFactoryMTJ.INSTANCE.createIdentity(this.getNumRows(), this.getNumColumns());
        Matrix AI = this.solve(I);
        return AI;
    }

    @Override
    public double normFrobenius() {
        return this.internalMatrix.norm(Matrix.Norm.Frobenius);
    }

    @Override
    public boolean isSymmetric(double effectiveZero) {
        if (!this.isSquare()) {
            throw new DimensionalityMismatchException(this.getNumRows(), this.getNumColumns());
        }
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = i + 1; j < this.getNumColumns(); ++j) {
                double difference = this.getElement(i, j) - this.getElement(j, i);
                if (!(Math.abs(difference) > effectiveZero)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void zero() {
        this.internalMatrix.zero();
    }

    @Override
    public int rank(double effectiveZero) {
        DenseMatrix svdDude = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        SingularValueDecompositionMTJ svd = SingularValueDecompositionMTJ.create(svdDude);
        return svd.effectiveRank(effectiveZero);
    }

    protected void transposeInto(AbstractMTJMatrix destinationMatrix) {
        this.internalMatrix.transpose(destinationMatrix.internalMatrix);
    }

    protected void getSubMatrixInto(int minRow, int maxRow, int minColumn, int maxColumn, AbstractMTJMatrix destinationMatrix) {
        if (destinationMatrix.getNumRows() != maxRow - minRow + 1 || destinationMatrix.getNumColumns() != maxColumn - minColumn + 1) {
            throw new DimensionalityMismatchException("Submatrix is incorrect size.");
        }
        for (int i = minRow; i <= maxRow; ++i) {
            for (int j = minColumn; j <= maxColumn; ++j) {
                destinationMatrix.setElement(i - minRow, j - minColumn, this.getElement(i, j));
            }
        }
    }

    protected void timesInto(AbstractMTJMatrix multiplicationMatrix, AbstractMTJMatrix destinationMatrix) {
        int M = this.getNumRows();
        int N = multiplicationMatrix.getNumColumns();
        if (M != destinationMatrix.getNumRows() || N != destinationMatrix.getNumColumns()) {
            throw new DimensionalityMismatchException("Multiplication dimensions do not agree.");
        }
        this.internalMatrix.mult(multiplicationMatrix.internalMatrix, destinationMatrix.internalMatrix);
    }

    protected void timesInto(AbstractMTJVector multiplicationVector, AbstractMTJVector destinationVector) {
        int M = this.getNumRows();
        if (M != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, destinationVector.getDimensionality());
        }
        this.internalMatrix.mult(multiplicationVector.getInternalVector(), destinationVector.getInternalVector());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        int N;
        int M = this.getNumRows();
        if (M * (N = this.getNumColumns()) != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Elements in this does not equal elements in parameters");
        }
        int index = 0;
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < M; ++i) {
                this.setElement(i, j, parameters.getElement(index));
                ++index;
            }
        }
    }

    @Override
    public DenseVector convertToVector() {
        int M = this.getNumRows();
        int N = this.getNumColumns();
        DenseVector parameters = new DenseVector(M * N);
        int index = 0;
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < M; ++i) {
                parameters.setElement(index, this.getElement(i, j));
                ++index;
            }
        }
        return parameters;
    }

    class AbstractMTJMatrixEntry
    implements MatrixEntry {
        private int rowIndex;
        private int columnIndex;

        AbstractMTJMatrixEntry() {
            this(0, 0);
        }

        AbstractMTJMatrixEntry(int rowIndex, int columnIndex) {
            this.setRowIndex(rowIndex);
            this.setColumnIndex(columnIndex);
        }

        @Override
        public double getValue() {
            return AbstractMTJMatrix.this.getElement(this.getRowIndex(), this.getColumnIndex());
        }

        @Override
        public void setValue(double value) {
            AbstractMTJMatrix.this.setElement(this.getRowIndex(), this.getColumnIndex(), value);
        }

        @Override
        public int getRowIndex() {
            return this.rowIndex;
        }

        @Override
        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public int getColumnIndex() {
            return this.columnIndex;
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }
    }

    class AbstractMTJMatrixIterator
    implements Iterator<MatrixEntry> {
        private Iterator<no.uib.cipr.matrix.MatrixEntry> internalIterator;
        private MatrixEntry entry = null;

        public AbstractMTJMatrixIterator() {
            this.setInternalIterator(AbstractMTJMatrix.this.internalMatrix.iterator());
            this.setEntry(new AbstractMTJMatrixEntry());
        }

        protected Iterator<no.uib.cipr.matrix.MatrixEntry> getInternalIterator() {
            return this.internalIterator;
        }

        protected void setInternalIterator(Iterator<no.uib.cipr.matrix.MatrixEntry> internalIterator) {
            this.internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.getInternalIterator().hasNext();
        }

        @Override
        public MatrixEntry next() {
            no.uib.cipr.matrix.MatrixEntry internalNext = this.getInternalIterator().next();
            this.getEntry().setRowIndex(internalNext.row());
            this.getEntry().setColumnIndex(internalNext.column());
            return this.getEntry();
        }

        @Override
        public void remove() {
            this.getInternalIterator().remove();
        }

        public MatrixEntry getEntry() {
            return this.entry;
        }

        public void setEntry(MatrixEntry entry) {
            this.entry = entry;
        }
    }
}

