/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.matrix.DiagonalMatrix;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.DiagonalMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;

public abstract class MatrixFactory<MatrixType extends Matrix>
implements Serializable {
    protected static final MatrixFactory<? extends Matrix> DEFAULT_DENSE_INSTANCE = new DenseMatrixFactoryMTJ();
    protected static final MatrixFactory<? extends Matrix> DEFAULT_SPARSE_INSTANCE = new SparseMatrixFactoryMTJ();
    protected static final DiagonalMatrixFactoryMTJ DEFAULT_DIAGONAL_INSTANCE = new DiagonalMatrixFactoryMTJ();

    protected MatrixFactory() {
    }

    public static MatrixFactory<? extends Matrix> getDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static MatrixFactory<? extends Matrix> getDenseDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static MatrixFactory<? extends Matrix> getSparseDefault() {
        return DEFAULT_SPARSE_INSTANCE;
    }

    public static MatrixFactory<? extends DiagonalMatrix> getDiagonalDefault() {
        return DEFAULT_DIAGONAL_INSTANCE;
    }

    public abstract MatrixType copyMatrix(Matrix var1);

    public MatrixType copyArray(double[][] values) {
        int M = values.length;
        int N = 0;
        if (M > 0) {
            N = values[0].length;
        }
        MatrixType m = this.createMatrix(M, N);
        for (int i = 0; i < M; ++i) {
            if (values[i].length != N) {
                throw new IllegalArgumentException("Array columns are not same size!");
            }
            for (int j = 0; j < N; ++j) {
                m.setElement(i, j, values[i][j]);
            }
        }
        return m;
    }

    public abstract MatrixType createMatrix(int var1, int var2);

    public MatrixType createIdentity(int numRows, int numColumns) {
        MatrixType m = this.createMatrix(numRows, numColumns);
        m.identity();
        return m;
    }

    public MatrixType createUniformRandom(int numRows, int numColumns, double min, double max, Random random) {
        MatrixType m = this.createMatrix(numRows, numColumns);
        for (int i = 0; i < m.getNumRows(); ++i) {
            for (int j = 0; j < m.getNumColumns(); ++j) {
                double uniform = random.nextDouble();
                double value = (max - min) * uniform + min;
                m.setElement(i, j, value);
            }
        }
        return m;
    }

    public MatrixType copyRowVectors(Collection<? extends Vectorizable> rows) {
        int numRows = rows.size();
        int numColumns = VectorUtil.safeGetDimensionality(CollectionUtil.getFirst(rows));
        MatrixType result = this.createMatrix(numRows, numColumns);
        int rowIndex = 0;
        for (Vectorizable vectorizable : rows) {
            result.setRow(rowIndex, vectorizable.convertToVector());
            ++rowIndex;
        }
        return result;
    }

    public MatrixType copyRowVectors(Vectorizable ... rows) {
        return this.copyRowVectors(Arrays.asList(rows));
    }

    public MatrixType copyColumnVectors(Collection<? extends Vectorizable> columns) {
        int numRows = VectorUtil.safeGetDimensionality(CollectionUtil.getFirst(columns));
        int numColumns = columns.size();
        MatrixType result = this.createMatrix(numRows, numColumns);
        int columnIndex = 0;
        for (Vectorizable vectorizable : columns) {
            result.setColumn(columnIndex, vectorizable.convertToVector());
            ++columnIndex;
        }
        return result;
    }

    public MatrixType copyColumnVectors(Vectorizable ... columns) {
        return this.copyColumnVectors(Arrays.asList(columns));
    }

    public MatrixType createDiagonal(Vectorizable diagonal) {
        Vector vector = diagonal.convertToVector();
        int dimensionality = vector.getDimensionality();
        MatrixType result = this.createMatrix(dimensionality, dimensionality);
        for (VectorEntry entry : vector) {
            int i = entry.getIndex();
            result.setElement(i, i, entry.getValue());
        }
        return result;
    }
}

