/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Collection;

public class WeightedNumberAverager
extends AbstractCloneableSerializable
implements Summarizer<WeightedValue<? extends Number>, Double> {
    public static final WeightedNumberAverager INSTANCE = new WeightedNumberAverager();

    @Override
    public Double summarize(Collection<? extends WeightedValue<? extends Number>> data) {
        return WeightedNumberAverager.weightedAverage(data);
    }

    public static double weightedAverage(Iterable<? extends WeightedValue<? extends Number>> data) {
        double weightedSum = 0.0;
        double totalWeight = 0.0;
        for (WeightedValue<? extends Number> weightedValue : data) {
            double value = weightedValue.getValue().doubleValue();
            double weight = weightedValue.getWeight();
            weightedSum += value * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0) {
            return 0.0;
        }
        return weightedSum / totalWeight;
    }
}

