/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.Vector1;
import gov.sandia.cognition.util.CloneableSerializable;

public class MutableLong
extends Number
implements CloneableSerializable,
Comparable<MutableLong>,
Ring<MutableLong>,
Vectorizable {
    private static final long serialVersionUID = 20110602L;
    public long value;

    public MutableLong() {
        this(0L);
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(MutableLong other) {
        this(other.value);
    }

    @Override
    public MutableLong clone() {
        try {
            return (MutableLong)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof MutableLong && this.equals((MutableLong)other);
    }

    public boolean equals(MutableLong other) {
        return this.equals(other.value);
    }

    public boolean equals(long other) {
        return this.value == other;
    }

    @Override
    public int compareTo(MutableLong other) {
        if (this.value < other.value) {
            return -1;
        }
        if (this.value == other.value) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public boolean equals(MutableLong other, double effectiveZero) {
        return (double)Math.abs(this.value - other.value) <= effectiveZero;
    }

    @Override
    public MutableLong plus(MutableLong other) {
        return new MutableLong(this.value + other.value);
    }

    @Override
    public void plusEquals(MutableLong other) {
        this.value += other.value;
    }

    @Override
    public MutableLong minus(MutableLong other) {
        return new MutableLong(this.value - other.value);
    }

    @Override
    public void minusEquals(MutableLong other) {
        this.value -= other.value;
    }

    @Override
    public MutableLong dotTimes(MutableLong other) {
        return new MutableLong(this.value * other.value);
    }

    @Override
    public void dotTimesEquals(MutableLong other) {
        this.value *= other.value;
    }

    @Override
    public MutableLong scale(double scaleFactor) {
        return new MutableLong((long)((double)this.value * scaleFactor));
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.value = (long)((double)this.value * scaleFactor);
    }

    @Override
    public MutableLong negative() {
        return new MutableLong(-this.value);
    }

    @Override
    public void negativeEquals() {
        this.value = -this.value;
    }

    @Override
    public void zero() {
        this.value = 0L;
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public boolean isZero(double effectiveZero) {
        return (double)Math.abs(this.value) <= effectiveZero;
    }

    @Override
    public Vector1 convertToVector() {
        return new Vector1(this.value);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.value = (long)parameters.getElement(0);
    }
}

