/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.Vector1;
import gov.sandia.cognition.util.CloneableSerializable;

public class MutableInteger
extends Number
implements CloneableSerializable,
Comparable<MutableInteger>,
Ring<MutableInteger>,
Vectorizable {
    private static final long serialVersionUID = 20110601L;
    public int value;

    public MutableInteger() {
        this(0);
    }

    public MutableInteger(int value) {
        this.value = value;
    }

    public MutableInteger(MutableInteger other) {
        this(other.value);
    }

    @Override
    public MutableInteger clone() {
        try {
            return (MutableInteger)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof MutableInteger && this.equals((MutableInteger)other);
    }

    public boolean equals(MutableInteger other) {
        return this.equals(other.value);
    }

    public boolean equals(int other) {
        return this.value == other;
    }

    @Override
    public int compareTo(MutableInteger other) {
        if (this.value < other.value) {
            return -1;
        }
        if (this.value == other.value) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public boolean equals(MutableInteger other, double effectiveZero) {
        return (double)Math.abs(this.value - other.value) <= effectiveZero;
    }

    @Override
    public MutableInteger plus(MutableInteger other) {
        return new MutableInteger(this.value + other.value);
    }

    @Override
    public void plusEquals(MutableInteger other) {
        this.value += other.value;
    }

    @Override
    public MutableInteger minus(MutableInteger other) {
        return new MutableInteger(this.value - other.value);
    }

    @Override
    public void minusEquals(MutableInteger other) {
        this.value -= other.value;
    }

    @Override
    public MutableInteger dotTimes(MutableInteger other) {
        return new MutableInteger(this.value * other.value);
    }

    @Override
    public void dotTimesEquals(MutableInteger other) {
        this.value *= other.value;
    }

    @Override
    public MutableInteger scale(double scaleFactor) {
        return new MutableInteger((int)((double)this.value * scaleFactor));
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.value = (int)((double)this.value * scaleFactor);
    }

    @Override
    public MutableInteger negative() {
        return new MutableInteger(-this.value);
    }

    @Override
    public void negativeEquals() {
        this.value = -this.value;
    }

    @Override
    public void zero() {
        this.value = 0;
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public boolean isZero(double effectiveZero) {
        return (double)Math.abs(this.value) <= effectiveZero;
    }

    @Override
    public Vector1 convertToVector() {
        return new Vector1((double)this.value);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.value = (int)parameters.getElement(0);
    }
}

