/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.LogMath;
import gov.sandia.cognition.math.Ring;

public class LogNumber
extends Number
implements Ring<LogNumber> {
    protected double logValue;

    public LogNumber() {
        this(Double.NEGATIVE_INFINITY);
    }

    protected LogNumber(double logValue) {
        this.logValue = logValue;
    }

    public LogNumber(LogNumber other) {
        this.logValue = other.logValue;
    }

    public static LogNumber createFromValue(double value) {
        return new LogNumber(Math.log(value));
    }

    public static LogNumber createFromLogValue(double logValue) {
        return new LogNumber(logValue);
    }

    @Override
    public LogNumber clone() {
        try {
            return (LogNumber)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LogNumber plus(LogNumber other) {
        return new LogNumber(LogMath.add(this.logValue, other.logValue));
    }

    @Override
    public void plusEquals(LogNumber other) {
        this.logValue = LogMath.add(this.logValue, other.logValue);
    }

    @Override
    public LogNumber minus(LogNumber other) {
        return new LogNumber(LogMath.subtract(this.logValue, other.logValue));
    }

    @Override
    public void minusEquals(LogNumber other) {
        this.logValue = LogMath.subtract(this.logValue, other.logValue);
    }

    public LogNumber times(LogNumber other) {
        return new LogNumber(this.logValue + other.logValue);
    }

    public void timesEquals(LogNumber other) {
        this.logValue += other.logValue;
    }

    public LogNumber divide(LogNumber other) {
        return new LogNumber(this.logValue - other.logValue);
    }

    public void divideEquals(LogNumber other) {
        this.logValue -= other.logValue;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LogNumber && this.equals((LogNumber)other, 0.0);
    }

    @Override
    public boolean equals(LogNumber other, double effectiveZero) {
        if (this.logValue >= other.logValue) {
            return LogMath.subtract(this.logValue, other.logValue) <= Math.log(effectiveZero);
        }
        return LogMath.subtract(other.logValue, this.logValue) <= Math.log(effectiveZero);
    }

    @Override
    public LogNumber dotTimes(LogNumber other) {
        return this.times(other);
    }

    @Override
    public void dotTimesEquals(LogNumber other) {
        this.timesEquals(other);
    }

    @Override
    public LogNumber scale(double scaleFactor) {
        return new LogNumber(this.logValue + Math.log(scaleFactor));
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.logValue += Math.log(scaleFactor);
    }

    @Override
    public LogNumber negative() {
        return new LogNumber(Double.NaN);
    }

    @Override
    public void negativeEquals() {
        this.logValue = Double.NaN;
    }

    @Override
    public void zero() {
        this.logValue = Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isZero() {
        return this.logValue == Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isZero(double effectiveZero) {
        return this.logValue <= Math.log(effectiveZero);
    }

    public double getValue() {
        return Math.exp(this.logValue);
    }

    public void setValue(double value) {
        this.logValue = Math.log(value);
    }

    public double getLogValue() {
        return this.logValue;
    }

    public void setLogValue(double logValue) {
        this.logValue = logValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.logValue) ^ Double.doubleToLongBits(this.logValue) >>> 32);
        return hash;
    }

    public String toString() {
        return "exp(" + this.logValue + ")";
    }

    @Override
    public int intValue() {
        return (int)this.getValue();
    }

    @Override
    public long longValue() {
        return (long)this.getValue();
    }

    @Override
    public float floatValue() {
        return (float)this.getValue();
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }
}

