/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.evaluator;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Removed redundant claim to implement Serializable", "Looks good."})
public class ValueMapper<InputType, OutputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, OutputType> {
    protected Map<InputType, OutputType> valueMap;

    public ValueMapper() {
        this(new HashMap());
    }

    public ValueMapper(Map<InputType, OutputType> valueMap) {
        this.setValueMap(valueMap);
    }

    @Override
    public ValueMapper<InputType, OutputType> clone() {
        ValueMapper result = (ValueMapper)super.clone();
        result.valueMap = ObjectUtil.cloneSmart(this.valueMap);
        return result;
    }

    @Override
    public OutputType evaluate(InputType input) {
        return this.valueMap.get(input);
    }

    public Map<InputType, OutputType> getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map<InputType, OutputType> valueMap) {
        this.valueMap = valueMap;
    }

    public static <InputType, OutputType> ValueMapper<InputType, OutputType> create(Map<InputType, OutputType> valueMap) {
        return new ValueMapper<InputType, OutputType>(valueMap);
    }
}

