/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.collection.MultiCollection;
import gov.sandia.cognition.collection.MultiIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Looks fine."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2007-12-10", changesNeeded=false, comments={"Minor updates to the javadoc."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-18", changesNeeded=false, comments={"Looks fine."})})
public class DefaultMultiCollection<EntryType>
extends AbstractCollection<EntryType>
implements Serializable,
MultiCollection<EntryType> {
    private List<Collection<EntryType>> collections;

    public DefaultMultiCollection(Collection<EntryType> first, Collection<EntryType> second) {
        this.setCollections(new ArrayList<Collection<EntryType>>());
        this.collections.add(first);
        this.collections.add(second);
    }

    public DefaultMultiCollection(Collection<? extends Collection<EntryType>> collections) {
        this.setCollections(new ArrayList<Collection<EntryType>>(collections));
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<EntryType> collection : this.collections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int sizeSum = 0;
        for (Collection<EntryType> collection : this.collections) {
            sizeSum += collection.size();
        }
        return sizeSum;
    }

    @Override
    public int getSubCollectionsCount() {
        return this.collections.size();
    }

    @Override
    public Iterator<EntryType> iterator() {
        return new MultiIterator<EntryType>(this.collections);
    }

    @Override
    public Collection<? extends Collection<EntryType>> subCollections() {
        return this.collections;
    }

    private void setCollections(List<Collection<EntryType>> collections) {
        this.collections = collections;
    }
}

