/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.upconversion.internal;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.VariableManager;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionErrorCode;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptions;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;

abstract class UpConversionHandlerBase
implements CommandHandler {
    UpConversionHandlerBase() {
    }

    protected UpConversionOptions ensureGetAuthorUpconversionOptions(DOMBuilder builder) {
        VariableManager variableManager = builder.getVariableManager();
        UpConversionOptions options = (UpConversionOptions)variableManager.getVariable("upconversion", "options");
        if (options == null) {
            options = new UpConversionOptions();
            variableManager.setVariable("upconversion", "options", (Object)options);
        }
        return options;
    }

    protected Element ensureLegalSymbolTarget(DOMBuilder builder, Element parentElement, CommandToken token, NodeList targetNodeList) throws SnuggleParseException {
        if (targetNodeList.getLength() != 1 && !MathMLUtilities.isMathMLElement((Node)targetNodeList.item(0))) {
            builder.appendOrThrowError(parentElement, (Token)token, (ErrorCode)UpConversionErrorCode.UAESY1, new Object[0]);
            return null;
        }
        Element targetElement = (Element)targetNodeList.item(0);
        String localName = targetElement.getLocalName();
        if ("msub".equals(localName)) {
            if (this.ensureLegalSymbolTarget(builder, parentElement, token, targetElement.getChildNodes()) == null) {
                return null;
            }
        } else if (!"mn".equals(localName) && !"mi".equals(localName)) {
            builder.appendOrThrowError(parentElement, (Token)token, (ErrorCode)UpConversionErrorCode.UAESY1, new Object[0]);
            return null;
        }
        return targetElement;
    }
}

