/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.Span;
import opennlp.uima.parser.ParserModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Parser
extends CasAnnotator_ImplBase {
    private static final String PARSE_TYPE_PARAMETER = "opennlp.uima.ParseType";
    public static final String TYPE_FEATURE_PARAMETER = "opennlp.uima.TypeFeature";
    protected UimaContext context;
    protected Logger mLogger;
    private Type mSentenceType;
    private Type mTokenType;
    protected opennlp.tools.parser.Parser mParser;
    private Type mParseType;
    private Feature mTypeFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ParserModel model;
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Parser.");
        }
        try {
            ParserModelResource modelResource = (ParserModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mParser = ParserFactory.create((ParserModel)model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mParseType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, PARSE_TYPE_PARAMETER);
        this.mTypeFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mParseType, TYPE_FEATURE_PARAMETER, "uima.cas.String");
    }

    public void process(CAS cas) {
        AnnotationIndex sentences = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentence : sentences) {
            this.process(cas, sentence);
        }
    }

    protected void process(CAS cas, AnnotationFS sentenceAnnotation) {
        AnnotationIndex allTokens = cas.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(sentenceAnnotation);
        FSIterator containingTokens = cas.createFilteredIterator(allTokens.iterator(), (FSMatchConstraint)containingConstraint);
        StringBuilder sentenceStringBuilder = new StringBuilder();
        while (containingTokens.hasNext()) {
            AnnotationFS token = (AnnotationFS)containingTokens.next();
            sentenceStringBuilder.append(token.getCoveredText());
            sentenceStringBuilder.append(' ');
        }
        String sentence = sentenceStringBuilder.toString();
        sentence = sentenceAnnotation.getCoveredText();
        containingTokens = cas.createFilteredIterator(allTokens.iterator(), (FSMatchConstraint)containingConstraint);
        LinkedList<Span> tokenSpans = new LinkedList<Span>();
        while (containingTokens.hasNext()) {
            AnnotationFS token = (AnnotationFS)containingTokens.next();
            tokenSpans.add(new Span(token.getBegin() - sentenceAnnotation.getBegin(), token.getEnd() - sentenceAnnotation.getBegin()));
        }
        ParseConverter converter = new ParseConverter(sentence, tokenSpans.toArray(new Span[tokenSpans.size()]));
        Parse parse = this.mParser.parse(converter.getParseForTagger());
        parse = converter.transformParseFromTagger(parse);
        if (this.mLogger.isLoggable(Level.INFO)) {
            StringBuffer parseString = new StringBuffer();
            parse.show(parseString);
            this.mLogger.log(Level.INFO, parseString.toString());
        }
        this.createAnnotation(cas, sentenceAnnotation.getBegin(), parse);
    }

    protected void createAnnotation(CAS cas, int offset, Parse parse) {
        Parse[] parseChildrens = parse.getChildren();
        for (int i = 0; i < parseChildrens.length; ++i) {
            Parse child = parseChildrens[i];
            this.createAnnotation(cas, offset, child);
        }
        AnnotationFS parseAnnotation = cas.createAnnotation(this.mParseType, offset + parse.getSpan().getStart(), offset + parse.getSpan().getEnd());
        parseAnnotation.setStringValue(this.mTypeFeature, parse.getType());
        cas.getIndexRepository().addFS((FeatureStructure)parseAnnotation);
    }

    public void destroy() {
        this.mParser = null;
    }

    private static class ParseConverter {
        private Map<Integer, Integer> mIndexMap = new HashMap<Integer, Integer>();
        private Parse mParseForTagger;
        private String mSentence;

        public ParseConverter(String sentence, Span[] tokens) {
            this.mSentence = sentence;
            StringBuilder sentenceStringBuilder = new StringBuilder();
            String[] tokenList = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String escapedToken;
                String tokenString = ((Object)tokens[i].getCoveredText((CharSequence)sentence)).toString();
                tokenList[i] = escapedToken = ParseConverter.escape(tokenString);
                int escapedStart = sentenceStringBuilder.length();
                int start = tokens[i].getStart();
                this.mIndexMap.put(new Integer(escapedStart), new Integer(start));
                int escapedEnd = escapedStart + escapedToken.length();
                int end = tokens[i].getEnd();
                this.mIndexMap.put(new Integer(escapedEnd), new Integer(end));
                sentenceStringBuilder.append(tokenList[i]);
                sentenceStringBuilder.append(' ');
            }
            sentenceStringBuilder.setLength(sentenceStringBuilder.length() - 1);
            String tokenizedSentence = sentenceStringBuilder.toString();
            this.mParseForTagger = new Parse(tokenizedSentence, new Span(0, tokenizedSentence.length()), "INC", 1.0, null);
            int start = 0;
            for (int i = 0; i < tokenList.length; ++i) {
                this.mParseForTagger.insert(new Parse(tokenizedSentence, new Span(start, start + tokenList[i].length()), "TK", 0.0, 0));
                start += tokenList[i].length() + 1;
            }
        }

        private static String escape(String text) {
            return text;
        }

        Parse getParseForTagger() {
            return this.mParseForTagger;
        }

        Parse transformParseFromTagger(Parse parseFromTagger) {
            int start = parseFromTagger.getSpan().getStart();
            int end = parseFromTagger.getSpan().getEnd();
            Parse transformedParse = new Parse(this.mSentence, new Span(this.mIndexMap.get(new Integer(start)).intValue(), this.mIndexMap.get(new Integer(end)).intValue()), parseFromTagger.getType(), parseFromTagger.getProb(), parseFromTagger.getHeadIndex());
            Parse[] parseFromTaggerChildrens = parseFromTagger.getChildren();
            for (int i = 0; i < parseFromTaggerChildrens.length; ++i) {
                Parse child = parseFromTaggerChildrens[i];
                if (child.getType().equals("TK") || child.getChildCount() <= 0 || child.getChildren()[0].getType().equals("TK")) continue;
                transformedParse.insert(this.transformParseFromTagger(child));
            }
            if (parseFromTagger.getType().equals("TOP")) {
                return transformedParse.getChildren()[0];
            }
            return transformedParse;
        }
    }
}

