/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream output, ImageEncodeParam param) {
        super(output, param);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage im) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam encodeParam = (TIFFEncodeParam)this.param;
        Iterator iter = encodeParam.getExtraImages();
        if (iter != null) {
            boolean hasNext;
            int ifdOffset = 8;
            RenderedImage nextImage = im;
            TIFFEncodeParam nextParam = encodeParam;
            do {
                ifdOffset = this.encode(nextImage, nextParam, ifdOffset, !(hasNext = iter.hasNext()));
                if (!hasNext) continue;
                Object obj = iter.next();
                if (obj instanceof RenderedImage) {
                    nextImage = (RenderedImage)obj;
                    nextParam = encodeParam;
                    continue;
                }
                if (!(obj instanceof Object[])) continue;
                Object[] o = (Object[])obj;
                nextImage = (RenderedImage)o[0];
                nextParam = (TIFFEncodeParam)o[1];
            } while (hasNext);
        } else {
            this.encode(im, encodeParam, 8, true);
        }
    }

    public Object encodeMultiple(Object context, RenderedImage img) throws IOException {
        TIFFEncodeParam encodeParam = (TIFFEncodeParam)this.param;
        if (encodeParam.getExtraImages() != null) {
            throw new IllegalStateException("Extra images may not be used when calling encodeMultiple!");
        }
        Context c = (Context)context;
        if (c == null) {
            c = new Context();
            this.writeFileHeader();
        } else {
            c.ifdOffset = this.encode(c.nextImage, encodeParam, c.ifdOffset, false);
        }
        c.nextImage = img;
        return c;
    }

    public void finishMultiple(Object context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        Context c = (Context)context;
        TIFFEncodeParam encodeParam = (TIFFEncodeParam)this.param;
        c.ifdOffset = this.encode(c.nextImage, encodeParam, c.ifdOffset, true);
    }

    private int encode(RenderedImage im, TIFFEncodeParam encodeParam, int ifdOffset, boolean isLast) throws IOException {
        TIFFField[] extraFields;
        int tileHeight;
        int tileWidth;
        byte[] b;
        byte[] g;
        byte[] r;
        int compression = encodeParam.getCompression();
        boolean isTiled = encodeParam.getWriteTiled();
        int minX = im.getMinX();
        int minY = im.getMinY();
        int width = im.getWidth();
        int height = im.getHeight();
        SampleModel sampleModel = im.getSampleModel();
        int[] sampleSize = sampleModel.getSampleSize();
        for (int i = 1; i < sampleSize.length; ++i) {
            if (sampleSize[i] == sampleSize[0]) continue;
            throw new Error("TIFFImageEncoder0");
        }
        int numBands = sampleModel.getNumBands();
        if ((sampleSize[0] == 1 || sampleSize[0] == 4) && numBands != 1) {
            throw new Error("TIFFImageEncoder1");
        }
        int dataType = sampleModel.getDataType();
        switch (dataType) {
            case 0: {
                if (sampleSize[0] == 1 || sampleSize[0] != 4 || sampleSize[0] == 8) break;
                throw new Error("TIFFImageEncoder2");
            }
            case 1: 
            case 2: {
                if (sampleSize[0] == 16) break;
                throw new Error("TIFFImageEncoder3");
            }
            case 3: 
            case 4: {
                if (sampleSize[0] == 32) break;
                throw new Error("TIFFImageEncoder4");
            }
            default: {
                throw new Error("TIFFImageEncoder5");
            }
        }
        boolean dataTypeIsShort = dataType == 2 || dataType == 1;
        ColorModel colorModel = im.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && dataType != 0) {
            throw new Error("TIFFImageEncoder6");
        }
        IndexColorModel icm = null;
        int sizeOfColormap = 0;
        char[] colormap = null;
        int imageType = -1;
        int numExtraSamples = 0;
        int extraSampleType = 0;
        if (colorModel instanceof IndexColorModel) {
            icm = (IndexColorModel)colorModel;
            int mapSize = icm.getMapSize();
            if (sampleSize[0] == 1 && numBands == 1) {
                if (mapSize != 2) {
                    throw new IllegalArgumentException("TIFFImageEncoder7");
                }
                r = new byte[mapSize];
                icm.getReds(r);
                g = new byte[mapSize];
                icm.getGreens(g);
                b = new byte[mapSize];
                icm.getBlues(b);
                imageType = (r[0] & 0xFF) == 0 && (r[1] & 0xFF) == 255 && (g[0] & 0xFF) == 0 && (g[1] & 0xFF) == 255 && (b[0] & 0xFF) == 0 && (b[1] & 0xFF) == 255 ? 1 : ((r[0] & 0xFF) == 255 && (r[1] & 0xFF) == 0 && (g[0] & 0xFF) == 255 && (g[1] & 0xFF) == 0 && (b[0] & 0xFF) == 255 && (b[1] & 0xFF) == 0 ? 0 : 3);
            } else if (numBands == 1) {
                imageType = 3;
            }
        } else if (colorModel == null) {
            if (sampleSize[0] == 1 && numBands == 1) {
                imageType = 1;
            } else {
                imageType = 8;
                if (numBands > 1) {
                    numExtraSamples = numBands - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    imageType = 5;
                    break;
                }
                case 6: {
                    imageType = 2;
                    break;
                }
                case 1: {
                    imageType = 7;
                    break;
                }
                case 5: {
                    if (compression == 7 && encodeParam.getJPEGCompressRGBToYCbCr()) {
                        imageType = 6;
                        break;
                    }
                    imageType = 4;
                    break;
                }
                case 3: {
                    imageType = 6;
                    break;
                }
                default: {
                    imageType = 8;
                }
            }
            if (imageType == 8) {
                numExtraSamples = numBands - 1;
            } else if (numBands > 1) {
                numExtraSamples = numBands - colorSpace.getNumComponents();
            }
            if (numExtraSamples == 1 && colorModel.hasAlpha()) {
                int n = extraSampleType = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (imageType == -1) {
            throw new Error("TIFFImageEncoder8");
        }
        if (compression == 7) {
            if (imageType == 3) {
                throw new Error("TIFFImageEncoder11");
            }
            if (sampleSize[0] != 8 || imageType != 2 && imageType != 4 && imageType != 6) {
                throw new Error("TIFFImageEncoder9");
            }
        }
        int photometricInterpretation = -1;
        switch (imageType) {
            case 0: {
                photometricInterpretation = 0;
                break;
            }
            case 1: {
                photometricInterpretation = 1;
                break;
            }
            case 2: 
            case 8: {
                photometricInterpretation = 1;
                break;
            }
            case 3: {
                photometricInterpretation = 3;
                icm = (IndexColorModel)colorModel;
                sizeOfColormap = icm.getMapSize();
                r = new byte[sizeOfColormap];
                icm.getReds(r);
                g = new byte[sizeOfColormap];
                icm.getGreens(g);
                b = new byte[sizeOfColormap];
                icm.getBlues(b);
                int redIndex = 0;
                int greenIndex = sizeOfColormap;
                int blueIndex = 2 * sizeOfColormap;
                colormap = new char[sizeOfColormap * 3];
                for (int i = 0; i < sizeOfColormap; ++i) {
                    int tmp = 0xFF & r[i];
                    colormap[redIndex++] = (char)(tmp << 8 | tmp);
                    tmp = 0xFF & g[i];
                    colormap[greenIndex++] = (char)(tmp << 8 | tmp);
                    tmp = 0xFF & b[i];
                    colormap[blueIndex++] = (char)(tmp << 8 | tmp);
                }
                sizeOfColormap *= 3;
                break;
            }
            case 4: {
                photometricInterpretation = 2;
                break;
            }
            case 5: {
                photometricInterpretation = 5;
                break;
            }
            case 6: {
                photometricInterpretation = 6;
                break;
            }
            case 7: {
                photometricInterpretation = 8;
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder8");
            }
        }
        if (isTiled) {
            tileWidth = encodeParam.getTileWidth() > 0 ? encodeParam.getTileWidth() : im.getTileWidth();
            tileHeight = encodeParam.getTileHeight() > 0 ? encodeParam.getTileHeight() : im.getTileHeight();
        } else {
            tileWidth = width;
            tileHeight = encodeParam.getTileHeight() > 0 ? encodeParam.getTileHeight() : 8;
        }
        JPEGEncodeParam jep = null;
        if (compression == 7) {
            int factorH;
            jep = encodeParam.getJPEGEncodeParam();
            int maxSubH = jep.getHorizontalSubsampling(0);
            int maxSubV = jep.getVerticalSubsampling(0);
            for (int i = 1; i < numBands; ++i) {
                int subV;
                int subH = jep.getHorizontalSubsampling(i);
                if (subH > maxSubH) {
                    maxSubH = subH;
                }
                if ((subV = jep.getVerticalSubsampling(i)) <= maxSubV) continue;
                maxSubV = subV;
            }
            int factorV = 8 * maxSubV;
            if ((tileHeight = (int)((float)tileHeight / (float)factorV + 0.5f) * factorV) < factorV) {
                tileHeight = factorV;
            }
            if (isTiled && (tileWidth = (int)((float)tileWidth / (float)(factorH = 8 * maxSubH) + 0.5f) * factorH) < factorH) {
                tileWidth = factorH;
            }
        }
        int numTiles = isTiled ? (width + tileWidth - 1) / tileWidth * ((height + tileHeight - 1) / tileHeight) : (int)Math.ceil((double)height / (double)tileHeight);
        long[] tileByteCounts = new long[numTiles];
        long bytesPerRow = (long)Math.ceil((double)sampleSize[0] / 8.0 * (double)tileWidth * (double)numBands);
        long bytesPerTile = bytesPerRow * (long)tileHeight;
        for (int i = 0; i < numTiles; ++i) {
            tileByteCounts[i] = bytesPerTile;
        }
        if (!isTiled) {
            long lastStripRows = height - tileHeight * (numTiles - 1);
            tileByteCounts[numTiles - 1] = lastStripRows * bytesPerRow;
        }
        long totalBytesOfData = bytesPerTile * (long)(numTiles - 1) + tileByteCounts[numTiles - 1];
        long[] tileOffsets = new long[numTiles];
        TreeSet<TIFFField> fields = new TreeSet<TIFFField>();
        fields.add(new TIFFField(256, 4, 1, new long[]{width}));
        fields.add(new TIFFField(257, 4, 1, new long[]{height}));
        char[] shortSampleSize = new char[numBands];
        for (int i = 0; i < numBands; ++i) {
            shortSampleSize[i] = (char)sampleSize[i];
        }
        fields.add(new TIFFField(258, 3, numBands, shortSampleSize));
        fields.add(new TIFFField(259, 3, 1, new char[]{(char)compression}));
        fields.add(new TIFFField(262, 3, 1, new char[]{(char)photometricInterpretation}));
        if (!isTiled) {
            fields.add(new TIFFField(273, 4, numTiles, tileOffsets));
        }
        fields.add(new TIFFField(277, 3, 1, new char[]{(char)numBands}));
        if (!isTiled) {
            fields.add(new TIFFField(278, 4, 1, new long[]{tileHeight}));
            fields.add(new TIFFField(279, 4, numTiles, tileByteCounts));
        }
        if (colormap != null) {
            fields.add(new TIFFField(320, 3, sizeOfColormap, colormap));
        }
        if (isTiled) {
            fields.add(new TIFFField(322, 4, 1, new long[]{tileWidth}));
            fields.add(new TIFFField(323, 4, 1, new long[]{tileHeight}));
            fields.add(new TIFFField(324, 4, numTiles, tileOffsets));
            fields.add(new TIFFField(325, 4, numTiles, tileByteCounts));
        }
        if (numExtraSamples > 0) {
            char[] extraSamples = new char[numExtraSamples];
            for (int i = 0; i < numExtraSamples; ++i) {
                extraSamples[i] = (char)extraSampleType;
            }
            fields.add(new TIFFField(338, 3, numExtraSamples, extraSamples));
        }
        if (dataType != 0) {
            char[] sampleFormat = new char[numBands];
            sampleFormat[0] = dataType == 4 ? 3 : (dataType == 1 ? 1 : 2);
            for (int b2 = 1; b2 < numBands; ++b2) {
                sampleFormat[b2] = sampleFormat[0];
            }
            fields.add(new TIFFField(339, 3, numBands, sampleFormat));
        }
        JPEGEncodeParam jpegEncodeParam = null;
        JPEGImageEncoder jpegEncoder = null;
        int jpegColorID = 0;
        if (compression == 7) {
            jpegColorID = 0;
            switch (imageType) {
                case 2: 
                case 3: {
                    jpegColorID = 1;
                    break;
                }
                case 4: {
                    if (colorModel.hasAlpha()) {
                        jpegColorID = 6;
                        break;
                    }
                    jpegColorID = 2;
                    break;
                }
                case 6: {
                    jpegColorID = colorModel.hasAlpha() ? 7 : 3;
                }
            }
            Raster tile00 = im.getTile(0, 0);
            jpegEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)tile00, (int)jpegColorID);
            TIFFImageEncoder.modifyEncodeParam(jep, jpegEncodeParam, numBands);
            jpegEncodeParam.setImageInfoValid(false);
            jpegEncodeParam.setTableInfoValid(true);
            ByteArrayOutputStream tableStream = new ByteArrayOutputStream();
            jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)tableStream, (JPEGEncodeParam)jpegEncodeParam);
            jpegEncoder.encode(tile00);
            byte[] tableData = tableStream.toByteArray();
            fields.add(new TIFFField(347, 7, tableData.length, tableData));
            jpegEncoder = null;
        }
        if (imageType == 6) {
            char subsampleH = '\u0001';
            char subsampleV = '\u0001';
            if (compression == 7) {
                subsampleH = (char)jep.getHorizontalSubsampling(0);
                subsampleV = (char)jep.getVerticalSubsampling(0);
                for (int i = 1; i < numBands; ++i) {
                    char subV;
                    char subH = (char)jep.getHorizontalSubsampling(i);
                    if (subH > subsampleH) {
                        subsampleH = subH;
                    }
                    if ((subV = (char)jep.getVerticalSubsampling(i)) <= subsampleV) continue;
                    subsampleV = subV;
                }
            }
            fields.add(new TIFFField(530, 3, 2, new char[]{subsampleH, subsampleV}));
            fields.add(new TIFFField(531, 3, 1, new char[]{(char)(compression == 7 ? 1 : 2)}));
            long[][] refbw = compression == 7 ? new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            fields.add(new TIFFField(532, 5, 6, refbw));
        }
        if ((extraFields = encodeParam.getExtraFields()) != null) {
            ArrayList<Integer> extantTags = new ArrayList<Integer>(fields.size());
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                TIFFField fld = (TIFFField)fieldIter.next();
                extantTags.add(new Integer(fld.getTag()));
            }
            int numExtraFields = extraFields.length;
            for (int i = 0; i < numExtraFields; ++i) {
                TIFFField fld = extraFields[i];
                Integer tagValue = new Integer(fld.getTag());
                if (extantTags.contains(tagValue)) continue;
                fields.add(fld);
                extantTags.add(tagValue);
            }
        }
        int dirSize = this.getDirectorySize(fields);
        tileOffsets[0] = ifdOffset + dirSize;
        OutputStream outCache = null;
        byte[] compressBuf = null;
        File tempFile = null;
        int nextIFDOffset = 0;
        boolean skipByte = false;
        Deflater deflater = null;
        boolean jpegRGBToYCbCr = false;
        if (compression == 1) {
            int numBytesPadding = 0;
            if (sampleSize[0] == 16 && tileOffsets[0] % 2L != 0L) {
                numBytesPadding = 1;
                tileOffsets[0] = tileOffsets[0] + 1L;
            } else if (sampleSize[0] == 32 && tileOffsets[0] % 4L != 0L) {
                numBytesPadding = (int)(4L - tileOffsets[0] % 4L);
                tileOffsets[0] = tileOffsets[0] + (long)numBytesPadding;
            }
            for (int i = 1; i < numTiles; ++i) {
                tileOffsets[i] = tileOffsets[i - 1] + tileByteCounts[i - 1];
            }
            if (!isLast && ((nextIFDOffset = (int)(tileOffsets[0] + totalBytesOfData)) & 1) != 0) {
                ++nextIFDOffset;
                skipByte = true;
            }
            this.writeDirectory(ifdOffset, fields, nextIFDOffset);
            if (numBytesPadding != 0) {
                for (int padding = 0; padding < numBytesPadding; ++padding) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(tileOffsets[0]);
            } else {
                outCache = this.output;
                try {
                    tempFile = File.createTempFile("jai-SOS-", ".tmp");
                    tempFile.deleteOnExit();
                    RandomAccessFile raFile = new RandomAccessFile(tempFile, "rw");
                    this.output = new SeekableOutputStream(raFile);
                }
                catch (Exception e) {
                    this.output = new ByteArrayOutputStream((int)totalBytesOfData);
                }
            }
            int bufSize = 0;
            switch (compression) {
                case 32773: {
                    bufSize = (int)(bytesPerTile + (bytesPerRow + 127L) / 128L * (long)tileHeight);
                    break;
                }
                case 7: {
                    bufSize = 0;
                    if (imageType != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    jpegRGBToYCbCr = true;
                    break;
                }
                case 32946: {
                    bufSize = (int)bytesPerTile;
                    deflater = new Deflater(encodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    bufSize = 0;
                }
            }
            if (bufSize != 0) {
                compressBuf = new byte[bufSize];
            }
        }
        int[] pixels = null;
        float[] fpixels = null;
        boolean checkContiguous = sampleSize[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && dataType == 0 || sampleSize[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] bpixels = null;
        if (compression != 7) {
            if (dataType == 0) {
                bpixels = new byte[tileHeight * tileWidth * numBands];
            } else if (dataTypeIsShort) {
                bpixels = new byte[2 * tileHeight * tileWidth * numBands];
            } else if (dataType == 3 || dataType == 4) {
                bpixels = new byte[4 * tileHeight * tileWidth * numBands];
            }
        }
        int lastRow = minY + height;
        int lastCol = minX + width;
        int tileNum = 0;
        for (int row = minY; row < lastRow; row += tileHeight) {
            int rows = isTiled ? tileHeight : Math.min(tileHeight, lastRow - row);
            int size = rows * tileWidth * numBands;
            block54: for (int col = minX; col < lastCol; col += tileWidth) {
                int i;
                Raster src = im.getData(new Rectangle(col, row, tileWidth, rows));
                boolean useDataBuffer = false;
                if (compression != 7) {
                    if (checkContiguous) {
                        if (sampleSize[0] == 8) {
                            ComponentSampleModel csm = (ComponentSampleModel)src.getSampleModel();
                            int[] bankIndices = csm.getBankIndices();
                            int[] bandOffsets = csm.getBandOffsets();
                            int pixelStride = csm.getPixelStride();
                            int lineStride = csm.getScanlineStride();
                            if (pixelStride != numBands || (long)lineStride != bytesPerRow) {
                                useDataBuffer = false;
                            } else {
                                useDataBuffer = true;
                                for (i = 0; useDataBuffer && i < numBands; ++i) {
                                    if (bankIndices[i] == 0 && bandOffsets[i] == i) continue;
                                    useDataBuffer = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)src.getSampleModel();
                            if (mpp.getNumBands() == 1 && mpp.getDataBitOffset() == 0 && mpp.getPixelBitStride() == 1) {
                                useDataBuffer = true;
                            }
                        }
                    }
                    if (!useDataBuffer) {
                        if (dataType == 4) {
                            fpixels = src.getPixels(col, row, tileWidth, rows, fpixels);
                        } else {
                            pixels = src.getPixels(col, row, tileWidth, rows, pixels);
                        }
                    }
                }
                int pixel = 0;
                int k = 0;
                switch (sampleSize[0]) {
                    case 1: {
                        int j;
                        int i2;
                        int j2;
                        int outOffset;
                        if (useDataBuffer) {
                            byte[] btmp = ((DataBufferByte)src.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)src.getSampleModel();
                            int lineStride = mpp.getScanlineStride();
                            int inOffset = mpp.getOffset(col - src.getSampleModelTranslateX(), row - src.getSampleModelTranslateY());
                            if (lineStride == (int)bytesPerRow) {
                                System.arraycopy(btmp, inOffset, bpixels, 0, (int)bytesPerRow * rows);
                            } else {
                                outOffset = 0;
                                for (j2 = 0; j2 < rows; ++j2) {
                                    System.arraycopy(btmp, inOffset, bpixels, outOffset, (int)bytesPerRow);
                                    inOffset += lineStride;
                                    outOffset += (int)bytesPerRow;
                                }
                            }
                        } else {
                            int index = 0;
                            for (i2 = 0; i2 < rows; ++i2) {
                                for (j = 0; j < tileWidth / 8; ++j) {
                                    pixel = pixels[index++] << 7 | pixels[index++] << 6 | pixels[index++] << 5 | pixels[index++] << 4 | pixels[index++] << 3 | pixels[index++] << 2 | pixels[index++] << 1 | pixels[index++];
                                    bpixels[k++] = (byte)pixel;
                                }
                                if (tileWidth % 8 <= 0) continue;
                                pixel = 0;
                                for (j = 0; j < tileWidth % 8; ++j) {
                                    pixel |= pixels[index++] << 7 - j;
                                }
                                bpixels[k++] = (byte)pixel;
                            }
                        }
                        if (compression == 1) {
                            this.output.write(bpixels, 0, rows * ((tileWidth + 7) / 8));
                            continue block54;
                        }
                        if (compression == 32773) {
                            int numCompressedBytes = TIFFImageEncoder.compressPackBits(bpixels, rows, (int)bytesPerRow, compressBuf);
                            tileByteCounts[tileNum++] = numCompressedBytes;
                            this.output.write(compressBuf, 0, numCompressedBytes);
                            continue block54;
                        }
                        if (compression != 32946) continue block54;
                        int numCompressedBytes = TIFFImageEncoder.deflate(deflater, bpixels, compressBuf);
                        tileByteCounts[tileNum++] = numCompressedBytes;
                        this.output.write(compressBuf, 0, numCompressedBytes);
                        continue block54;
                    }
                    case 4: {
                        int numCompressedBytes;
                        int j;
                        int i2;
                        int index = 0;
                        for (i2 = 0; i2 < rows; ++i2) {
                            for (j = 0; j < tileWidth / 2; ++j) {
                                pixel = pixels[index++] << 4 | pixels[index++];
                                bpixels[k++] = (byte)pixel;
                            }
                            if ((tileWidth & 1) != 1) continue;
                            pixel = pixels[index++] << 4;
                            bpixels[k++] = (byte)pixel;
                        }
                        if (compression == 1) {
                            this.output.write(bpixels, 0, rows * ((tileWidth + 1) / 2));
                            continue block54;
                        }
                        if (compression == 32773) {
                            numCompressedBytes = TIFFImageEncoder.compressPackBits(bpixels, rows, (int)bytesPerRow, compressBuf);
                            tileByteCounts[tileNum++] = numCompressedBytes;
                            this.output.write(compressBuf, 0, numCompressedBytes);
                            continue block54;
                        }
                        if (compression != 32946) continue block54;
                        numCompressedBytes = TIFFImageEncoder.deflate(deflater, bpixels, compressBuf);
                        tileByteCounts[tileNum++] = numCompressedBytes;
                        this.output.write(compressBuf, 0, numCompressedBytes);
                        continue block54;
                    }
                    case 8: {
                        int numCompressedBytes;
                        int i2;
                        int j2;
                        int outOffset;
                        if (compression != 7) {
                            if (useDataBuffer) {
                                byte[] btmp = ((DataBufferByte)src.getDataBuffer()).getData();
                                ComponentSampleModel csm = (ComponentSampleModel)src.getSampleModel();
                                int inOffset = csm.getOffset(col - src.getSampleModelTranslateX(), row - src.getSampleModelTranslateY());
                                int lineStride = csm.getScanlineStride();
                                if (lineStride == (int)bytesPerRow) {
                                    System.arraycopy(btmp, inOffset, bpixels, 0, (int)bytesPerRow * rows);
                                } else {
                                    outOffset = 0;
                                    for (j2 = 0; j2 < rows; ++j2) {
                                        System.arraycopy(btmp, inOffset, bpixels, outOffset, (int)bytesPerRow);
                                        inOffset += lineStride;
                                        outOffset += (int)bytesPerRow;
                                    }
                                }
                            } else {
                                for (i2 = 0; i2 < size; ++i2) {
                                    bpixels[i2] = (byte)pixels[i2];
                                }
                            }
                        }
                        if (compression == 1) {
                            this.output.write(bpixels, 0, size);
                            continue block54;
                        }
                        if (compression == 32773) {
                            numCompressedBytes = TIFFImageEncoder.compressPackBits(bpixels, rows, (int)bytesPerRow, compressBuf);
                            tileByteCounts[tileNum++] = numCompressedBytes;
                            this.output.write(compressBuf, 0, numCompressedBytes);
                            continue block54;
                        }
                        if (compression == 7) {
                            long startPos = this.getOffset(this.output);
                            if (jpegEncoder == null || jpegEncodeParam.getWidth() != src.getWidth() || jpegEncodeParam.getHeight() != src.getHeight()) {
                                jpegEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)src, (int)jpegColorID);
                                TIFFImageEncoder.modifyEncodeParam(jep, jpegEncodeParam, numBands);
                                jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (JPEGEncodeParam)jpegEncodeParam);
                            }
                            if (jpegRGBToYCbCr) {
                                WritableRaster wRas = null;
                                if (src instanceof WritableRaster) {
                                    wRas = (WritableRaster)src;
                                } else {
                                    wRas = src.createCompatibleWritableRaster();
                                    wRas.setRect(src);
                                }
                                if (wRas.getMinX() != 0 || wRas.getMinY() != 0) {
                                    wRas = wRas.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bi = new BufferedImage(colorModel, wRas, false, null);
                                jpegEncoder.encode(bi);
                            } else {
                                jpegEncoder.encode(src.createTranslatedChild(0, 0));
                            }
                            long endPos = this.getOffset(this.output);
                            tileByteCounts[tileNum++] = (int)(endPos - startPos);
                            continue block54;
                        }
                        if (compression != 32946) continue block54;
                        numCompressedBytes = TIFFImageEncoder.deflate(deflater, bpixels, compressBuf);
                        tileByteCounts[tileNum++] = numCompressedBytes;
                        this.output.write(compressBuf, 0, numCompressedBytes);
                        continue block54;
                    }
                    case 16: {
                        int numCompressedBytes;
                        int ls = 0;
                        for (int i3 = 0; i3 < size; ++i3) {
                            int value = pixels[i3];
                            bpixels[ls++] = (byte)((value & 0xFF00) >> 8);
                            bpixels[ls++] = (byte)(value & 0xFF);
                        }
                        if (compression == 1) {
                            this.output.write(bpixels, 0, size * 2);
                            continue block54;
                        }
                        if (compression == 32773) {
                            numCompressedBytes = TIFFImageEncoder.compressPackBits(bpixels, rows, (int)bytesPerRow, compressBuf);
                            tileByteCounts[tileNum++] = numCompressedBytes;
                            this.output.write(compressBuf, 0, numCompressedBytes);
                            continue block54;
                        }
                        if (compression != 32946) continue block54;
                        numCompressedBytes = TIFFImageEncoder.deflate(deflater, bpixels, compressBuf);
                        tileByteCounts[tileNum++] = numCompressedBytes;
                        this.output.write(compressBuf, 0, numCompressedBytes);
                        continue block54;
                    }
                    case 32: {
                        int numCompressedBytes;
                        if (dataType == 3) {
                            int li = 0;
                            for (i = 0; i < size; ++i) {
                                int value = pixels[i];
                                bpixels[li++] = (byte)((value & 0xFF000000) >>> 24);
                                bpixels[li++] = (byte)((value & 0xFF0000) >>> 16);
                                bpixels[li++] = (byte)((value & 0xFF00) >>> 8);
                                bpixels[li++] = (byte)(value & 0xFF);
                            }
                        } else {
                            int lf = 0;
                            for (i = 0; i < size; ++i) {
                                int value = Float.floatToIntBits(fpixels[i]);
                                bpixels[lf++] = (byte)((value & 0xFF000000) >>> 24);
                                bpixels[lf++] = (byte)((value & 0xFF0000) >>> 16);
                                bpixels[lf++] = (byte)((value & 0xFF00) >>> 8);
                                bpixels[lf++] = (byte)(value & 0xFF);
                            }
                        }
                        if (compression == 1) {
                            this.output.write(bpixels, 0, size * 4);
                            continue block54;
                        }
                        if (compression == 32773) {
                            numCompressedBytes = TIFFImageEncoder.compressPackBits(bpixels, rows, (int)bytesPerRow, compressBuf);
                            tileByteCounts[tileNum++] = numCompressedBytes;
                            this.output.write(compressBuf, 0, numCompressedBytes);
                            continue block54;
                        }
                        if (compression != 32946) continue block54;
                        numCompressedBytes = TIFFImageEncoder.deflate(deflater, bpixels, compressBuf);
                        tileByteCounts[tileNum++] = numCompressedBytes;
                        this.output.write(compressBuf, 0, numCompressedBytes);
                    }
                }
            }
        }
        if (compression == 1) {
            if (skipByte) {
                this.output.write(0);
            }
        } else {
            int totalBytes = 0;
            for (int i = 1; i < numTiles; ++i) {
                int numBytes = (int)tileByteCounts[i - 1];
                totalBytes += numBytes;
                tileOffsets[i] = tileOffsets[i - 1] + (long)numBytes;
            }
            int n = nextIFDOffset = isLast ? 0 : ifdOffset + dirSize + (totalBytes += (int)tileByteCounts[numTiles - 1]);
            if ((nextIFDOffset & 1) != 0) {
                ++nextIFDOffset;
                skipByte = true;
            }
            if (outCache == null) {
                if (skipByte) {
                    this.output.write(0);
                }
                SeekableOutputStream sos = (SeekableOutputStream)this.output;
                long savePos = sos.getFilePointer();
                sos.seek(ifdOffset);
                this.writeDirectory(ifdOffset, fields, nextIFDOffset);
                sos.seek(savePos);
            } else if (tempFile != null) {
                int bytesRead;
                FileInputStream fileStream = new FileInputStream(tempFile);
                this.output.close();
                this.output = outCache;
                this.writeDirectory(ifdOffset, fields, nextIFDOffset);
                byte[] copyBuffer = new byte[8192];
                for (int bytesCopied = 0; bytesCopied < totalBytes && (bytesRead = fileStream.read(copyBuffer)) != -1; bytesCopied += bytesRead) {
                    this.output.write(copyBuffer, 0, bytesRead);
                }
                fileStream.close();
                tempFile.delete();
                if (skipByte) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream memoryStream = (ByteArrayOutputStream)this.output;
                this.output = outCache;
                this.writeDirectory(ifdOffset, fields, nextIFDOffset);
                memoryStream.writeTo(this.output);
                if (skipByte) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return nextIFDOffset;
    }

    private int getDirectorySize(SortedSet fields) {
        int numEntries = fields.size();
        int dirSize = 2 + numEntries * 12 + 4;
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            TIFFField field = (TIFFField)iter.next();
            int valueSize = field.getCount() * sizeOfType[field.getType()];
            if (valueSize <= 4) continue;
            dirSize += valueSize;
        }
        return dirSize;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int thisIFDOffset, SortedSet fields, int nextIFDOffset) throws IOException {
        int numEntries = fields.size();
        long offsetBeyondIFD = thisIFDOffset + 12 * numEntries + 4 + 2;
        ArrayList<TIFFField> tooBig = new ArrayList<TIFFField>();
        this.writeUnsignedShort(numEntries);
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            TIFFField field = (TIFFField)iter.next();
            int tag = field.getTag();
            this.writeUnsignedShort(tag);
            int type = field.getType();
            this.writeUnsignedShort(type);
            int count = field.getCount();
            int valueSize = TIFFImageEncoder.getValueSize(field);
            this.writeLong(type == 2 ? (long)valueSize : (long)count);
            if (valueSize > 4) {
                this.writeLong(offsetBeyondIFD);
                offsetBeyondIFD += (long)valueSize;
                tooBig.add(field);
                continue;
            }
            this.writeValuesAsFourBytes(field);
        }
        this.writeLong(nextIFDOffset);
        for (int i = 0; i < tooBig.size(); ++i) {
            this.writeValues((TIFFField)tooBig.get(i));
        }
    }

    private static int getValueSize(TIFFField field) {
        int type = field.getType();
        int count = field.getCount();
        int valueSize = 0;
        if (type == 2) {
            for (int i = 0; i < count; ++i) {
                byte[] stringBytes = field.getAsString(i).getBytes();
                valueSize += stringBytes.length;
                if (stringBytes[stringBytes.length - 1] == 0) continue;
                ++valueSize;
            }
        } else {
            valueSize = count * sizeOfType[type];
        }
        return valueSize;
    }

    private void writeValuesAsFourBytes(TIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 1: {
                int i;
                byte[] bytes = field.getAsBytes();
                if (count > 4) {
                    count = 4;
                }
                for (i = 0; i < count; ++i) {
                    this.output.write(bytes[i]);
                }
                for (i = 0; i < 4 - count; ++i) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int i;
                char[] chars = field.getAsChars();
                if (count > 2) {
                    count = 2;
                }
                for (i = 0; i < count; ++i) {
                    this.writeUnsignedShort(chars[i]);
                }
                for (i = 0; i < 2 - count; ++i) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] longs = field.getAsLongs();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(longs[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 1: 
            case 6: 
            case 7: {
                byte[] bytes = field.getAsBytes();
                for (int i = 0; i < count; ++i) {
                    this.output.write(bytes[i]);
                }
                break;
            }
            case 3: {
                char[] chars = field.getAsChars();
                for (int i = 0; i < count; ++i) {
                    this.writeUnsignedShort(chars[i]);
                }
                break;
            }
            case 8: {
                short[] shorts = field.getAsShorts();
                for (int i = 0; i < count; ++i) {
                    this.writeUnsignedShort(shorts[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] longs = field.getAsLongs();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(longs[i]);
                }
                break;
            }
            case 11: {
                float[] floats = field.getAsFloats();
                for (int i = 0; i < count; ++i) {
                    int intBits = Float.floatToIntBits(floats[i]);
                    this.writeLong(intBits);
                }
                break;
            }
            case 12: {
                double[] doubles = field.getAsDoubles();
                for (int i = 0; i < count; ++i) {
                    long longBits = Double.doubleToLongBits(doubles[i]);
                    this.writeLong(longBits >>> 32);
                    this.writeLong(longBits & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] rationals = field.getAsRationals();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(rationals[i][0]);
                    this.writeLong(rationals[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < count; ++i) {
                    byte[] stringBytes = field.getAsString(i).getBytes();
                    this.output.write(stringBytes);
                    if (stringBytes[stringBytes.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error("TIFFImageEncoder10");
            }
        }
    }

    private void writeUnsignedShort(int s) throws IOException {
        this.output.write((s & 0xFF00) >>> 8);
        this.output.write(s & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)(l & 0xFFL));
    }

    private long getOffset(OutputStream out) throws IOException {
        if (out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)out).size();
        }
        if (out instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)out).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] data, int numRows, int bytesPerRow, byte[] compData) {
        int inOffset = 0;
        int outOffset = 0;
        for (int i = 0; i < numRows; ++i) {
            outOffset = TIFFImageEncoder.packBits(data, inOffset, bytesPerRow, compData, outOffset);
            inOffset += bytesPerRow;
        }
        return outOffset;
    }

    private static int packBits(byte[] input, int inOffset, int inCount, byte[] output, int outOffset) {
        int inMax = inOffset + inCount - 1;
        int inMaxMinus1 = inMax - 1;
        while (inOffset <= inMax) {
            int run;
            byte replicate = input[inOffset];
            for (run = 1; run < 127 && inOffset < inMax && input[inOffset] == input[inOffset + 1]; ++run, ++inOffset) {
            }
            if (run > 1) {
                ++inOffset;
                output[outOffset++] = (byte)(-(run - 1));
                output[outOffset++] = replicate;
            }
            int saveOffset = outOffset;
            for (run = 0; run < 128 && (inOffset < inMax && input[inOffset] != input[inOffset + 1] || inOffset < inMaxMinus1 && input[inOffset] != input[inOffset + 2]); ++run) {
                output[++outOffset] = input[inOffset++];
            }
            if (run > 0) {
                output[saveOffset] = (byte)(run - 1);
                ++outOffset;
            }
            if (inOffset != inMax) continue;
            if (run > 0 && run < 128) {
                int n = saveOffset;
                output[n] = (byte)(output[n] + 1);
                output[outOffset++] = input[inOffset++];
                continue;
            }
            output[outOffset++] = 0;
            output[outOffset++] = input[inOffset++];
        }
        return outOffset;
    }

    private static int deflate(Deflater deflater, byte[] inflated, byte[] deflated) {
        deflater.setInput(inflated);
        deflater.finish();
        int numCompressedBytes = deflater.deflate(deflated);
        deflater.reset();
        return numCompressedBytes;
    }

    private static void modifyEncodeParam(JPEGEncodeParam src, JPEGEncodeParam dst, int nbands) {
        dst.setDensityUnit(src.getDensityUnit());
        dst.setXDensity(src.getXDensity());
        dst.setYDensity(src.getYDensity());
        dst.setRestartInterval(src.getRestartInterval());
        for (int i = 0; i < 4; ++i) {
            JPEGQTable tbl = src.getQTable(i);
            if (tbl == null) continue;
            dst.setQTable(i, tbl);
        }
    }

    private class Context {
        private RenderedImage nextImage;
        private int ifdOffset = 8;

        private Context() {
        }
    }
}

