/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.threads;

import java.util.ArrayList;
import java.util.List;

public class RecursiveThreadExecutor {
    int maxThreads;
    List<Job> threads = new ArrayList<Job>();
    List<Task> tasks = new ArrayList<Task>();
    int waitingThreads = 0;

    public RecursiveThreadExecutor(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public RecursiveThreadExecutor() {
        this.maxThreads = Runtime.getRuntime().availableProcessors();
    }

    public void close() {
        for (Job j : this.threads) {
            j.interrupt();
            try {
                j.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.threads.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task t) {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.tasks.add(t);
            if (this.waitingThreads == 0) {
                if (this.threads.size() < this.maxThreads) {
                    this.createThread();
                }
            } else {
                this.tasks.notify();
            }
        }
    }

    void createThread() {
        Job t = new Job();
        this.threads.add(t);
        t.start();
    }

    Task waitForNewTask() throws InterruptedException {
        return this.waitForNewTask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Task waitForNewTask(Task taskEnd) throws InterruptedException {
        List<Task> list = this.tasks;
        synchronized (list) {
            ++this.waitingThreads;
            try {
                Task task;
                if (this.tasks.size() == 0) {
                    if (taskEnd != null) {
                        task = taskEnd;
                        synchronized (task) {
                            if (taskEnd.end) {
                                Task task2 = null;
                                return task2;
                            }
                        }
                    }
                    this.tasks.wait();
                    if (this.tasks.size() == 0) {
                        task = null;
                        return task;
                    }
                }
                task = this.tasks.remove(0);
                return task;
            }
            finally {
                --this.waitingThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTaskEnd(Task t) throws InterruptedException {
        while (true) {
            Task tt;
            if ((tt = this.waitForNewTask(t)) != null) {
                this.executeTaskFlag(tt);
                continue;
            }
            Task task = t;
            synchronized (task) {
                if (t.end) {
                    return;
                }
            }
        }
    }

    public void waitTermination(Task t) throws InterruptedException {
        if (!this.executeTaskFlag(t)) {
            this.waitTaskEnd(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeTaskFlag(Task t) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = t;
        synchronized (object) {
            if (t.end) {
                return true;
            }
            if (t.start) {
                return false;
            }
            t.start = true;
        }
        t.run();
        object = t;
        synchronized (object) {
            t.end = true;
        }
        object = this.tasks;
        synchronized (object) {
            this.tasks.notifyAll();
        }
        return true;
    }

    class Job
    extends Thread {
        public Job() {
            super("RecursiveThread - " + RecursiveThreadExecutor.this.threads.size());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Task t;
                    if ((t = RecursiveThreadExecutor.this.waitForNewTask()) == null) {
                        continue;
                    }
                    RecursiveThreadExecutor.this.executeTaskFlag(t);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public static class Task
    implements Runnable {
        Runnable r;
        boolean start = false;
        boolean end = false;

        public Task(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            this.r.run();
        }
    }
}

