/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class JsonAsserterImpl
implements JsonAsserter {
    private final Object jsonObject;

    public JsonAsserterImpl(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public <T> JsonAsserter assertThat(String path, Matcher<T> matcher) {
        Object obj = JsonPath.read((Object)this.jsonObject, (String)path, (Filter[])new Filter[0]);
        if (!matcher.matches(obj)) {
            throw new AssertionError((Object)String.format("JSON doesn't match.\nExpected:\n%s\nActual:\n%s", matcher.toString(), obj));
        }
        return this;
    }

    @Override
    public <T> JsonAsserter assertEquals(String path, T expected) {
        return this.assertThat(path, Matchers.equalTo(expected));
    }

    @Override
    public JsonAsserter assertNotDefined(String path) {
        try {
            Object o = JsonPath.read((Object)this.jsonObject, (String)path, (Filter[])new Filter[0]);
            throw new AssertionError((Object)String.format("Document contains the path <%s> but was expected not to.", path));
        }
        catch (InvalidPathException invalidPathException) {
            return this;
        }
    }

    @Override
    public JsonAsserter assertNull(String path) {
        return this.assertThat(path, Matchers.nullValue());
    }

    @Override
    public <T> JsonAsserter assertNotNull(String path) {
        return this.assertThat(path, Matchers.notNullValue());
    }

    @Override
    public JsonAsserter and() {
        return this;
    }
}

