/*
 * Decompiled with CFR 0.152.
 */
package org.geonames.wikipedia;

public class TextSummaryExtractor {
    public static String extractSummary(String string, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 > -1 && (stringBuilder.length() < n || n == 0) && n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '{') {
                n3 = TextSummaryExtractor.skipTemplate(string, n3);
                continue;
            }
            if (c == '<') {
                if (string.length() > n3 + 1 && string.charAt(n3 + 1) == '!') {
                    n3 = TextSummaryExtractor.skipHTMLComment(string, n3);
                    continue;
                }
                n3 = TextSummaryExtractor.skipHTMLElement(string, n3);
                continue;
            }
            if (c == '[') {
                if (string.charAt(n3 + 1) == '[') {
                    n2 = string.indexOf("]]", n3);
                    int n4 = string.indexOf(":", n3);
                    if (n4 > -1 && n4 < n2) {
                        n3 = TextSummaryExtractor.findEndOfLink(string, n3);
                        continue;
                    }
                    int n5 = string.indexOf("|", n3);
                    if (n5 > -1 && n5 < n2) {
                        n3 = n5 + 1;
                        continue;
                    }
                    n3 += 2;
                    continue;
                }
            } else if (c == ']' && n3 + 1 < string.length() && string.charAt(n3 + 1) == ']') {
                n3 += 2;
                continue;
            }
            stringBuilder.append(c);
            ++n3;
        }
        String string2 = TextSummaryExtractor.removeWhiteSpace(stringBuilder.toString().replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ")).trim();
        n2 = (string2 = string2.replaceAll("&nbsp;", " ")).indexOf("==");
        if ((n2 < 20 || n2 > n) && (double)(n2 = string2.lastIndexOf(".")) < 0.7 * (double)n) {
            n2 = string2.lastIndexOf(" ");
        }
        if (n2 > -1 && n2 < string2.length()) {
            string2 = string2.substring(0, n2) + " (...)";
        }
        return string2.trim();
    }

    static int skipTemplate(String string, int n) {
        int n2;
        if (string.charAt(n) != '{') {
            return n;
        }
        int n3 = 1;
        for (n2 = n + 1; n3 > 0 && string.length() > n2; ++n2) {
            if (string.charAt(n2) == '{') {
                ++n3;
                continue;
            }
            if (string.charAt(n2) != '}') continue;
            --n3;
        }
        return n2;
    }

    static int skipHTMLElement(String string, int n) {
        int n2;
        if (string.charAt(n) != '<') {
            return n;
        }
        int n3 = 1;
        for (n2 = n + 1; n3 > 0 && string.length() > n2; ++n2) {
            if (string.charAt(n2) == '<') {
                ++n3;
                continue;
            }
            if (string.charAt(n2) != '>') continue;
            --n3;
        }
        return n2;
    }

    static int skipHTMLComment(String string, int n) {
        if (string.charAt(n) != '<' && string.charAt(n + 1) != '!') {
            return n;
        }
        int n2 = n;
        while ((n2 = string.indexOf(45, n2)) > -1) {
            if (string.length() < n2 + 2) {
                return string.length();
            }
            if (string.charAt(n2) == '-' && string.charAt(n2 + 1) == '-' && string.charAt(n2 + 2) == '>') {
                return n2 + 3;
            }
            ++n2;
        }
        return n2;
    }

    private static int findEndOfLink(String string, int n) {
        int n2 = string.indexOf("]]", n);
        if (n2 == -1) {
            return n;
        }
        int n3 = n;
        int n4 = string.indexOf("[[", n3);
        while (n4 > -1 && n4 < n2) {
            n3 = n2;
            n2 = string.indexOf("]]", n2 + 2);
            n4 = string.indexOf("[[", n2);
        }
        if (n2 != -1) {
            n3 = n2;
        }
        return n3;
    }

    public static String removeWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                if (n == 0) {
                    stringBuffer.append(cArray[i]);
                }
                ++n;
                continue;
            }
            stringBuffer.append(cArray[i]);
            n = 0;
        }
        return stringBuffer.toString();
    }
}

