/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.DefaultAuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AuthorizationProvider {
    static final Logger LOG = LoggerFactory.getLogger(FSDirectory.class);
    private static final ThreadLocal<Boolean> CLIENT_OP_TL = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static AuthorizationProvider defaultProvider;
    private static AuthorizationProvider provider;
    private static HashSet<String> usersToBypassExtAttrProvider;
    public static final int CURRENT_STATE_ID = 0x7FFFFFFE;

    static void beginClientOp() {
        CLIENT_OP_TL.set(Boolean.TRUE);
    }

    static void endClientOp() {
        CLIENT_OP_TL.set(Boolean.FALSE);
    }

    private static AuthorizationProvider getUserFilteredAttributeProvider(UserGroupInformation ugi) {
        if (provider == null || ugi != null && AuthorizationProvider.isUserBypassingExtAttrProvider(ugi.getUserName())) {
            return defaultProvider;
        }
        return provider;
    }

    public static AuthorizationProvider get() {
        if (!AuthorizationProvider.isUsersToBypassExtAttrProviderConfigured()) {
            return provider;
        }
        UserGroupInformation ugi = null;
        try {
            ugi = NameNode.getRemoteUser();
        }
        catch (IOException ioe) {
            LOG.warn("Call to NameNode.getRemoteUser() failed.", (Throwable)ioe);
        }
        return AuthorizationProvider.getUserFilteredAttributeProvider(ugi);
    }

    static void set(AuthorizationProvider authzProvider) {
        provider = authzProvider != null ? authzProvider : defaultProvider;
    }

    static void initUsersToBypassExtProvider(Configuration conf) {
        String[] bypassUsers = conf.getTrimmedStrings("dfs.namenode.authorization.provider.bypass.users", new String[]{""});
        for (int i = 0; i < bypassUsers.length; ++i) {
            String tmp = bypassUsers[i].trim();
            if (tmp.isEmpty()) continue;
            if (usersToBypassExtAttrProvider == null) {
                usersToBypassExtAttrProvider = new HashSet();
            }
            LOG.info("Add user " + tmp + " to the list that will bypass external" + " attribute provider.");
            usersToBypassExtAttrProvider.add(tmp);
        }
    }

    private static boolean isUsersToBypassExtAttrProviderConfigured() {
        return usersToBypassExtAttrProvider != null;
    }

    private static boolean isUserBypassingExtAttrProvider(String user) {
        return AuthorizationProvider.isUsersToBypassExtAttrProviderConfigured() && usersToBypassExtAttrProvider.contains(user);
    }

    protected final boolean isClientOp() {
        return CLIENT_OP_TL.get() == Boolean.TRUE;
    }

    public void start() {
    }

    public void stop() {
    }

    public void setSnaphottableDirs(Map<INodeAuthorizationInfo, Integer> snapshotableDirs) {
    }

    public void addSnapshottable(INodeAuthorizationInfo dir) {
    }

    public void removeSnapshottable(INodeAuthorizationInfo dir) {
    }

    public void createSnapshot(INodeAuthorizationInfo dir, int snapshotId) throws IOException {
    }

    public void removeSnapshot(INodeAuthorizationInfo dir, int snapshotId) throws IOException {
    }

    public abstract void setUser(INodeAuthorizationInfo var1, String var2);

    public abstract String getUser(INodeAuthorizationInfo var1, int var2);

    public abstract void setGroup(INodeAuthorizationInfo var1, String var2);

    public abstract String getGroup(INodeAuthorizationInfo var1, int var2);

    public abstract void setPermission(INodeAuthorizationInfo var1, FsPermission var2);

    public abstract FsPermission getFsPermission(INodeAuthorizationInfo var1, int var2);

    public abstract AclFeature getAclFeature(INodeAuthorizationInfo var1, int var2);

    public abstract void removeAclFeature(INodeAuthorizationInfo var1);

    public abstract void addAclFeature(INodeAuthorizationInfo var1, AclFeature var2);

    public abstract void checkPermission(String var1, Set<String> var2, INodeAuthorizationInfo[] var3, int var4, boolean var5, FsAction var6, FsAction var7, FsAction var8, FsAction var9, boolean var10) throws AccessControlException, UnresolvedLinkException;

    static {
        provider = defaultProvider = new DefaultAuthorizationProvider();
        usersToBypassExtAttrProvider = null;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static interface INodeAuthorizationInfo {
        public long getId();

        public String getLocalName();

        public INodeAuthorizationInfo getParent();

        public String getFullPathName();

        public boolean isDirectory();

        public String getUserName(int var1);

        public String getFsimageUserName(int var1);

        public String getGroupName(int var1);

        public String getFsimageGroupName(int var1);

        public FsPermission getFsPermission(int var1);

        public FsPermission getFsimageFsPermission(int var1);

        public AclFeature getAclFeature(int var1);

        public AclFeature getFsimageAclFeature(int var1);
    }
}

