/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util;

public class RunningStat {
    private int n = 0;
    private double m_oldM;
    private double m_newM;
    private double m_oldS;
    private double m_newS;

    public RunningStat() {
    }

    public RunningStat(double firstValue) {
        this.push(firstValue);
    }

    public void clear() {
        this.n = 0;
    }

    public void push(double x) {
        ++this.n;
        if (this.n == 1) {
            this.m_oldM = this.m_newM = x;
            this.m_oldS = 0.0;
        } else {
            this.m_newM = this.m_oldM + (x - this.m_oldM) / (double)this.n;
            this.m_newS = this.m_oldS + (x - this.m_oldM) * (x - this.m_newM);
            this.m_oldM = this.m_newM;
            this.m_oldS = this.m_newS;
        }
    }

    public int numDataValues() {
        return this.n;
    }

    public double mean() {
        return this.n > 0 ? this.m_newM : 0.0;
    }

    public double variance() {
        return this.n > 1 ? this.m_newS / (double)(this.n - 1) : 0.0;
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }
}

