/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import net.jafama.FastMath;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;

public final class GrahamScan {
    protected static boolean areAllCollinear(List<Point2d> Point2ds) {
        if (Point2ds.size() < 2) {
            return true;
        }
        Point2d a = Point2ds.get(0);
        Point2d b = Point2ds.get(1);
        for (int i = 2; i < Point2ds.size(); ++i) {
            Point2d c = Point2ds.get(i);
            if (GrahamScan.getTurn(a, b, c) == Turn.COLLINEAR) continue;
            return false;
        }
        return true;
    }

    public static Polygon getConvexHull(List<Point2d> Point2ds) {
        ArrayList<Point2d> sorted = new ArrayList<Point2d>(GrahamScan.getSortedPoint2dSet(Point2ds));
        if (sorted.size() <= 3) {
            return new Polygon(Point2ds);
        }
        if (GrahamScan.areAllCollinear(sorted)) {
            return new Polygon(Point2ds);
        }
        Stack stack = new Stack();
        stack.push(sorted.get(0));
        stack.push(sorted.get(1));
        block5: for (int i = 2; i < sorted.size(); ++i) {
            Point2d head = (Point2d)sorted.get(i);
            Point2d middle = (Point2d)stack.pop();
            Point2d tail = (Point2d)stack.peek();
            Turn turn = GrahamScan.getTurn(tail, middle, head);
            switch (turn) {
                case COUNTER_CLOCKWISE: {
                    stack.push(middle);
                    stack.push(head);
                    continue block5;
                }
                case CLOCKWISE: {
                    --i;
                    continue block5;
                }
                case COLLINEAR: {
                    stack.push(head);
                }
            }
        }
        stack.push(sorted.get(0));
        return new Polygon(stack);
    }

    protected static Point2d getLowestPoint2d(List<Point2d> Point2ds) {
        Point2d lowest = Point2ds.get(0);
        for (int i = 1; i < Point2ds.size(); ++i) {
            Point2d temp = Point2ds.get(i);
            if (!(temp.getY() < lowest.getY()) && (temp.getY() != lowest.getY() || !(temp.getX() < lowest.getX()))) continue;
            lowest = temp;
        }
        return lowest;
    }

    protected static Set<Point2d> getSortedPoint2dSet(List<Point2d> Point2ds) {
        final Point2d lowest = GrahamScan.getLowestPoint2d(Point2ds);
        TreeSet<Point2d> set = new TreeSet<Point2d>(new Comparator<Point2d>(){

            @Override
            public int compare(Point2d a, Point2d b) {
                double distanceB;
                double thetaB;
                if (a == b || a.equals(b)) {
                    return 0;
                }
                double thetaA = FastMath.atan2((double)(a.getY() - lowest.getY()), (double)(a.getX() - lowest.getX()));
                if (thetaA < (thetaB = FastMath.atan2((double)(b.getY() - lowest.getY()), (double)(b.getX() - lowest.getX())))) {
                    return -1;
                }
                if (thetaA > thetaB) {
                    return 1;
                }
                double distanceA = FastMath.sqrt((double)((lowest.getX() - a.getX()) * (lowest.getX() - a.getX()) + (lowest.getY() - a.getY()) * (lowest.getY() - a.getY())));
                if (distanceA < (distanceB = FastMath.sqrt((double)((lowest.getX() - b.getX()) * (lowest.getX() - b.getX()) + (lowest.getY() - b.getY()) * (lowest.getY() - b.getY()))))) {
                    return -1;
                }
                return 1;
            }
        });
        set.addAll(Point2ds);
        return set;
    }

    protected static Turn getTurn(Point2d a, Point2d b, Point2d c) {
        double crossProduct = (b.getX() - a.getX()) * (c.getY() - a.getY()) - (b.getY() - a.getY()) * (c.getX() - a.getX());
        if (crossProduct > 0.0) {
            return Turn.COUNTER_CLOCKWISE;
        }
        if (crossProduct < 0.0) {
            return Turn.CLOCKWISE;
        }
        return Turn.COLLINEAR;
    }

    protected static enum Turn {
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        COLLINEAR;

    }
}

