/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.patterns;

import java.util.regex.Pattern;
import org.openimaj.text.nlp.patterns.EntityPatternProvider;
import org.openimaj.text.nlp.patterns.PatternProvider;
import org.openimaj.text.nlp.patterns.PunctuationPatternProvider;

public class URLPatternProvider
extends PatternProvider {
    protected String Url;

    public URLPatternProvider(PunctuationPatternProvider punctuation, EntityPatternProvider entity) {
        String validLettersAndNumbersAndDots = "[a-z\\u00a1-\\uffff0-9\\-.]";
        this.Url = "\\b(?:(?:https?://|ftp://|www\\d{0,3}[.]))(?:\\S+(?::\\S*)?@)?(?:(?!10(?:\\.\\d{1,3}){3})(?!127(?:\\.\\d{1,3}){3})(?!169\\.254(?:\\.\\d{1,3}){2})(?!192\\.168(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:[a-z\\u00a1-\\uffff0-9\\-.])+(?:\\.(?:[a-z\\u00a1-\\uffff]{2,4})))(?::\\d{2,5})?(?:/[^\\s]*)?";
    }

    public URLPatternProvider() {
        this(new PunctuationPatternProvider(), new EntityPatternProvider());
    }

    @Override
    public String patternString() {
        return String.format("(%s)", this.Url);
    }

    @Override
    public Pattern pattern() {
        return Pattern.compile(this.patternString(), 66);
    }

    public static class DFURLPatternProvider
    extends URLPatternProvider {
        public DFURLPatternProvider() {
            this.Url = "\\b((?:https?://|www\\d{0,3}[.]|[A-Za-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))";
        }
    }
}

