/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openimaj.text.nlp.namedentity.EntityExtractionResourceBuilder;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.YagoEntityCandidateFinderFactory;
import org.openimaj.text.nlp.namedentity.YagoEntityContextScorerFactory;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;

public class YagoEntityExactMatcherFactory {
    public static YagoEntityExactMatcher getMatcher() {
        return YagoEntityExactMatcherFactory.getMatcher(EntityExtractionResourceBuilder.getDefaultRootPath());
    }

    public static YagoEntityExactMatcher getMatcher(String yagoEntityFolderPath) {
        YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder ycf = null;
        ycf = YagoEntityCandidateFinderFactory.createFromAliasFile(yagoEntityFolderPath + File.separator + EntityExtractionResourceBuilder.DEFAULT_ALIAS_NAME);
        YagoEntityContextScorerFactory.YagoEntityContextScorer ycs = null;
        ycs = YagoEntityContextScorerFactory.createFromIndexFile(yagoEntityFolderPath + File.separator + EntityExtractionResourceBuilder.DEFAULT_CONTEXT_NAME);
        return new YagoEntityExactMatcher(ycs, ycf);
    }

    public static class YagoEntityExactMatcher {
        private YagoEntityContextScorerFactory.YagoEntityContextScorer contextScorer;
        public YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder candidateFinder;

        public YagoEntityExactMatcher(YagoEntityContextScorerFactory.YagoEntityContextScorer contextScorer, YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder candidateFinder) {
            this.contextScorer = contextScorer;
            this.candidateFinder = candidateFinder;
        }

        public List<NamedEntity> matchExact(List<String> possibleEntityTokens, List<String> contextTokens) {
            ArrayList<NamedEntity> result = new ArrayList<NamedEntity>();
            List<List<NamedEntity>> candidates = this.candidateFinder.getCandidates(possibleEntityTokens);
            if (candidates.size() == 0) {
                return result;
            }
            for (List<NamedEntity> can : candidates) {
                ArrayList<String> companies = new ArrayList<String>();
                for (NamedEntity ent : can) {
                    companies.add(ent.rootName);
                }
                Map<NamedEntity, Float> contextScores = this.contextScorer.getScoresForEntityList((List<String>)companies, contextTokens);
                float topScore = 0.0f;
                NamedEntity resEntity = null;
                for (NamedEntity entity : can) {
                    if (!contextScores.keySet().contains(entity) || !(contextScores.get(entity).floatValue() > topScore)) continue;
                    resEntity = entity;
                    for (NamedEntity te : contextScores.keySet()) {
                        if (!resEntity.equals(te)) continue;
                        resEntity.type = te.type;
                    }
                    topScore = contextScores.get(entity).floatValue();
                }
                if (resEntity == null) continue;
                result.add(resEntity);
            }
            return result;
        }

        public List<NamedEntity> matchExact(List<TokenAnnotation> possibleEntityTokens, String context) {
            ArrayList<NamedEntity> result = new ArrayList<NamedEntity>();
            List<List<NamedEntity>> candidates = this.candidateFinder.getCandidatesFromReversableTokenList(possibleEntityTokens);
            if (candidates.size() == 0) {
                return result;
            }
            for (List<NamedEntity> can : candidates) {
                ArrayList<String> companies = new ArrayList<String>();
                for (NamedEntity ent : can) {
                    companies.add(ent.rootName);
                }
                Map<NamedEntity, Float> contextScores = this.contextScorer.getScoresForEntityList((List<String>)companies, context);
                float topScore = 0.0f;
                NamedEntity resEntity = null;
                for (NamedEntity entity : can) {
                    if (!contextScores.keySet().contains(entity) || !(contextScores.get(entity).floatValue() > topScore)) continue;
                    resEntity = entity;
                    for (NamedEntity te : contextScores.keySet()) {
                        if (!resEntity.equals(te)) continue;
                        resEntity.type = te.type;
                    }
                    topScore = contextScores.get(entity).floatValue();
                }
                if (resEntity == null) continue;
                result.add(resEntity);
            }
            return result;
        }
    }
}

