/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.namedentity.IgnoreTokenStripper;
import org.openimaj.text.nlp.namedentity.NGramGenerator;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;

public class YagoEntityCandidateFinderFactory {
    public static YagoEntityCandidateFinder createFromAliasFile(String pathToAliasFile) {
        HashMap result = new HashMap();
        FileInputStream fstream = null;
        try {
            fstream = new FileInputStream(pathToAliasFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String strLine = null;
        try {
            strLine = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String entity_Uri = null;
        while (strLine != null) {
            if (!strLine.startsWith("+") && !strLine.startsWith(".")) {
                try {
                    strLine = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (strLine.startsWith("+")) {
                entity_Uri = strLine.substring(1);
                try {
                    strLine = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            while (strLine != null && strLine.startsWith(".")) {
                String alias = strLine.substring(1).trim();
                if (result.containsKey(alias)) {
                    if (!((ArrayList)result.get(alias)).contains(entity_Uri)) {
                        ((ArrayList)result.get(alias)).add(entity_Uri);
                    }
                } else {
                    ArrayList<String> comps = new ArrayList<String>();
                    comps.add(entity_Uri);
                    result.put(alias, comps);
                }
                try {
                    strLine = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new YagoEntityCandidateFinder(result);
    }

    public static class YagoEntityCandidateFinder {
        private HashMap<String, ArrayList<String>> aliasMap;
        private IgnoreTokenStripper ss = new IgnoreTokenStripper(IgnoreTokenStripper.Language.English);
        private ArrayList<Integer> ngrams;

        private YagoEntityCandidateFinder(HashMap<String, ArrayList<String>> aliasMap) {
            this.aliasMap = aliasMap;
            this.setNgrams(1, 2, 3, 4, 5);
        }

        public void setNgrams(Integer ... ngrams) {
            HashSet<Integer> ngUnique = new HashSet<Integer>(Arrays.asList(ngrams));
            ArrayList<Integer> n = new ArrayList<Integer>(ngUnique);
            Collections.sort(n);
            this.ngrams = n;
        }

        public List<List<NamedEntity>> getCandidates(List<String> tokens) {
            HashMap<Integer, HashMap<Integer, List<NamedEntity>>> ngramEntities = new HashMap<Integer, HashMap<Integer, List<NamedEntity>>>();
            for (int i = 0; i < this.ngrams.size(); ++i) {
                ngramEntities.put(this.ngrams.get(i), this.getNgramEntities(this.ngrams.get(i), tokens));
            }
            Map top = (Map)ngramEntities.get(this.ngrams.get(this.ngrams.size() - 1));
            for (int i = 0; i < this.ngrams.size(); ++i) {
                int lowSize = this.ngrams.get(i);
                Map lowEnts = (Map)ngramEntities.get(lowSize);
                Iterator iterator = lowEnts.keySet().iterator();
                while (iterator.hasNext()) {
                    int startTokenLow = (Integer)iterator.next();
                    int endTokenLow = startTokenLow + lowSize - 1;
                    boolean collision = false;
                    block3: for (int j = i + 1; j < this.ngrams.size(); ++j) {
                        int highSize = this.ngrams.get(j);
                        Iterator iterator2 = ((Map)ngramEntities.get(highSize)).keySet().iterator();
                        while (iterator2.hasNext()) {
                            int startTokenHigh = (Integer)iterator2.next();
                            int endTokenHigh = startTokenHigh + highSize - 1;
                            if ((startTokenLow > endTokenHigh || startTokenLow < startTokenHigh) && (endTokenLow < startTokenHigh || endTokenLow > endTokenHigh)) continue;
                            collision = true;
                            break block3;
                        }
                    }
                    if (collision) continue;
                    top.put(startTokenLow, lowEnts.get(startTokenLow));
                }
            }
            ArrayList<List<NamedEntity>> rr = new ArrayList<List<NamedEntity>>();
            for (List entList : top.values()) {
                rr.add(entList);
            }
            return rr;
        }

        public List<List<NamedEntity>> getCandidatesFromReversableTokenList(List<TokenAnnotation> tokens) {
            HashMap<Integer, Map<Integer, List<NamedEntity>>> ngramEntities = new HashMap<Integer, Map<Integer, List<NamedEntity>>>();
            for (int i = 0; i < this.ngrams.size(); ++i) {
                ngramEntities.put(this.ngrams.get(i), this.getNgramEntitiesFromRTL(this.ngrams.get(i), tokens));
            }
            Map top = (Map)ngramEntities.get(this.ngrams.get(this.ngrams.size() - 1));
            for (int i = 0; i < this.ngrams.size(); ++i) {
                int lowSize = this.ngrams.get(i);
                Map lowEnts = (Map)ngramEntities.get(lowSize);
                Iterator iterator = lowEnts.keySet().iterator();
                while (iterator.hasNext()) {
                    int startTokenLow = (Integer)iterator.next();
                    int endTokenLow = startTokenLow + lowSize - 1;
                    boolean collision = false;
                    block3: for (int j = i + 1; j < this.ngrams.size(); ++j) {
                        int highSize = this.ngrams.get(j);
                        Iterator iterator2 = ((Map)ngramEntities.get(highSize)).keySet().iterator();
                        while (iterator2.hasNext()) {
                            int startTokenHigh = (Integer)iterator2.next();
                            int endTokenHigh = startTokenHigh + highSize - 1;
                            if ((startTokenLow > endTokenHigh || startTokenLow < startTokenHigh) && (endTokenLow < startTokenHigh || endTokenLow > endTokenHigh)) continue;
                            collision = true;
                            break block3;
                        }
                    }
                    if (collision) continue;
                    top.put(startTokenLow, lowEnts.get(startTokenLow));
                }
            }
            ArrayList<List<NamedEntity>> rr = new ArrayList<List<NamedEntity>>();
            for (List entList : top.values()) {
                rr.add(entList);
            }
            return rr;
        }

        private Map<Integer, List<NamedEntity>> getNgramEntitiesFromRTL(Integer n, List<TokenAnnotation> baseTokens) {
            NGramGenerator<TokenAnnotation> ngen = new NGramGenerator<TokenAnnotation>(TokenAnnotation.class);
            List<TokenAnnotation[]> ngrams = ngen.getNGrams(baseTokens, n);
            ArrayList<String> tokens = new ArrayList<String>();
            for (int i = 0; i < ngrams.size(); ++i) {
                tokens.add(ngrams.get(0)[0].reverse(Arrays.asList((Object[])ngrams.get(i))).trim());
            }
            HashMap<Integer, List<NamedEntity>> result = new HashMap<Integer, List<NamedEntity>>();
            for (int i = 0; i < tokens.size(); ++i) {
                ArrayList<String> matches;
                String token = (String)tokens.get(i);
                if (this.ss.isIgnoreToken(token) || (matches = this.getYagoCandidates(token)) == null) continue;
                ArrayList<NamedEntity> subRes = new ArrayList<NamedEntity>();
                for (String match : matches) {
                    NamedEntity ne = new NamedEntity();
                    TokenAnnotation[] ngram = ngrams.get(i);
                    ne.rootName = match;
                    ne.startChar = ngram[0].start;
                    ne.stopChar = ngram[ngram.length - 1].stop;
                    ne.type = NamedEntity.Type.Organisation;
                    subRes.add(ne);
                }
                result.put(i, subRes);
            }
            return result;
        }

        private HashMap<Integer, List<NamedEntity>> getNgramEntities(int n, List<String> baseTokens) {
            List<T[]> ngrams = new NGramGenerator.StringNGramGenerator().getNGrams(baseTokens, n);
            ArrayList<String> tokens = new ArrayList<String>();
            for (int i = 0; i < ngrams.size(); ++i) {
                tokens.add(StringUtils.join((Object[])ngrams.get(i), (String)" "));
            }
            HashMap<Integer, List<NamedEntity>> result = new HashMap<Integer, List<NamedEntity>>();
            for (int i = 0; i < tokens.size(); ++i) {
                ArrayList<String> matches;
                String token = (String)tokens.get(i);
                if (this.ss.isIgnoreToken(token) || (matches = this.getYagoCandidates(token)) == null) continue;
                ArrayList<NamedEntity> subRes = new ArrayList<NamedEntity>();
                for (String match : matches) {
                    NamedEntity ne = new NamedEntity();
                    ne.rootName = match;
                    ne.startToken = i;
                    ne.stopToken = i - 1 + n;
                    ne.type = NamedEntity.Type.Organisation;
                    subRes.add(ne);
                }
                result.put(i, subRes);
            }
            return result;
        }

        private ArrayList<String> getYagoCandidates(String token) {
            if (this.aliasMap.containsKey(token)) {
                ArrayList<String> result = this.aliasMap.get(token);
                return result;
            }
            return null;
        }
    }
}

