/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.twitter.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extractor {
    public List<String> extractMentionedScreennames(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> extracted = new ArrayList<String>();
        Matcher matcher = Regex.EXTRACT_MENTIONS.matcher(text);
        while (matcher.find()) {
            String after = text.substring(matcher.end());
            if (Regex.SCREEN_NAME_MATCH_END.matcher(after).find()) continue;
            extracted.add(matcher.group(2));
        }
        return extracted;
    }

    public List<Entity> extractMentionedScreennamesWithIndices(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<Entity> extracted = new ArrayList<Entity>();
        Matcher matcher = Regex.EXTRACT_MENTIONS.matcher(text);
        while (matcher.find()) {
            String after = text.substring(matcher.end());
            if (Regex.SCREEN_NAME_MATCH_END.matcher(after).find()) continue;
            extracted.add(new Entity(matcher, "mention", 2));
        }
        return extracted;
    }

    public String extractReplyScreenname(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = Regex.EXTRACT_REPLY.matcher(text);
        if (matcher.find()) {
            String after = text.substring(matcher.end());
            if (Regex.SCREEN_NAME_MATCH_END.matcher(after).find()) {
                return null;
            }
            return matcher.group(1);
        }
        return null;
    }

    public List<String> extractURLs(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Matcher matcher = Regex.VALID_URL.matcher(text);
        while (matcher.find()) {
            String url = matcher.group(3);
            Matcher tco_matcher = Regex.VALID_TCO_URL.matcher(url);
            if (tco_matcher.find()) {
                url = tco_matcher.group();
            }
            urls.add(url);
        }
        return urls;
    }

    public List<Entity> extractURLsWithIndices(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<Entity> urls = new ArrayList<Entity>();
        Matcher matcher = Regex.VALID_URL.matcher(text);
        while (matcher.find()) {
            Entity entity = new Entity(matcher, "url", 3, 0);
            String url = matcher.group(3);
            Matcher tco_matcher = Regex.VALID_TCO_URL.matcher(url);
            if (tco_matcher.find()) {
                entity.value = tco_matcher.group();
                entity.end = entity.start + entity.value.length();
            }
            urls.add(entity);
        }
        return urls;
    }

    public List<String> extractHashtags(String text) {
        if (text == null) {
            return null;
        }
        return this.extractList(Regex.AUTO_LINK_HASHTAGS, text, 3);
    }

    public List<Entity> extractHashtagsWithIndices(String text) {
        if (text == null) {
            return null;
        }
        return this.extractListWithIndices(Regex.AUTO_LINK_HASHTAGS, text, 3, "hashtag");
    }

    private List<String> extractList(Pattern pattern, String text, int groupNumber) {
        ArrayList<String> extracted = new ArrayList<String>();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String after = text.substring(matcher.end());
            if (Regex.HASHTAG_MATCH_END.matcher(after).find()) continue;
            extracted.add(matcher.group(groupNumber));
        }
        return extracted;
    }

    private List<Entity> extractListWithIndices(Pattern pattern, String text, int groupNumber, String valueType) {
        ArrayList<Entity> extracted = new ArrayList<Entity>();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            extracted.add(new Entity(matcher, valueType, groupNumber));
        }
        return extracted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entity {
        protected Integer start = null;
        protected Integer end = null;
        protected String value = null;
        protected String type = null;

        public Entity(Matcher matcher, String valueType, Integer groupNumber) {
            this(matcher, valueType, groupNumber, -1);
        }

        public Entity(Matcher matcher, String valueType, Integer groupNumber, int startOffset) {
            this.start = matcher.start(groupNumber) + startOffset;
            this.end = matcher.end(groupNumber);
            this.value = matcher.group(groupNumber);
            this.type = valueType;
        }

        public Entity(Map<String, Object> config, String valueType) {
            this.type = valueType;
            this.value = (String)config.get(valueType);
            List indices = (List)config.get("indices");
            this.start = (Integer)indices.get(0);
            this.end = (Integer)indices.get(1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entity)) {
                System.out.println("incorrect type");
                return false;
            }
            Entity other = (Entity)obj;
            return this.type.equals(other.type) && this.start.equals(other.start) && this.end.equals(other.end) && this.value.equals(other.value);
        }

        public int hashCode() {
            return this.type.hashCode() + this.value.hashCode() + this.start + this.end;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }
    }
}

