/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class RTimer {
    public static final int STARTED = 0;
    public static final int STOPPED = 1;
    public static final int PAUSED = 2;
    protected int state = 0;
    protected double startTime;
    protected double time = 0.0;
    protected double culmTime = 0.0;
    protected SimpleOrderedMap<RTimer> children = new SimpleOrderedMap();

    public RTimer() {
        this.startTime = this.now();
    }

    protected double now() {
        return System.currentTimeMillis();
    }

    public double stop() {
        assert (this.state == 0 || this.state == 2);
        this.time = this.culmTime;
        if (this.state == 0) {
            this.time += this.now() - this.startTime;
        }
        this.state = 1;
        for (Map.Entry entry : this.children) {
            RTimer child = (RTimer)entry.getValue();
            if (child.state != 0 && child.state != 2) continue;
            child.stop();
        }
        return this.time;
    }

    public void pause() {
        assert (this.state == 0);
        this.culmTime += this.now() - this.startTime;
        this.state = 2;
    }

    public void resume() {
        if (this.state == 0) {
            return;
        }
        assert (this.state == 2);
        this.state = 0;
        this.startTime = this.now();
    }

    public double getTime() {
        assert (this.state == 1);
        return this.time;
    }

    public RTimer sub(String desc) {
        RTimer child = (RTimer)this.children.get(desc);
        if (child == null) {
            child = new RTimer();
            this.children.add(desc, (Object)child);
        }
        return child;
    }

    public String toString() {
        return this.asNamedList().toString();
    }

    public NamedList asNamedList() {
        SimpleOrderedMap m = new SimpleOrderedMap();
        m.add("time", (Object)this.time);
        if (this.children.size() > 0) {
            for (Map.Entry entry : this.children) {
                m.add((String)entry.getKey(), (Object)((RTimer)entry.getValue()).asNamedList());
            }
        }
        return m;
    }

    public SimpleOrderedMap<RTimer> getChildren() {
        return this.children;
    }

    public static void main(String[] argv) throws InterruptedException {
        RTimer rt = new RTimer();
        Thread.sleep(100L);
        RTimer subt = rt.sub("sub1");
        Thread.sleep(50L);
        RTimer st = subt.sub("sub1.1");
        st.resume();
        Thread.sleep(10L);
        st.pause();
        Thread.sleep(50L);
        st.resume();
        Thread.sleep(10L);
        st.pause();
        subt.stop();
        rt.stop();
        System.out.println(rt.toString());
    }
}

