/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

public class BCDUtils {
    private static final char NEG_CHAR = '~';
    private static final int ZERO_EXPONENT = 97;

    private static int div10(int a) {
        return a * 52429 >>> 19;
    }

    private static int mul10(int a) {
        return a * 10;
    }

    public static int base10toBase100(char[] arr, int start, int end, char[] out, int outend) {
        int val;
        int wpos = outend;
        boolean neg = false;
        while (--end >= start && (val = arr[end]) != 43) {
            if (val == 45) {
                neg = !neg;
                break;
            }
            val -= 48;
            if (end > start) {
                char val2 = arr[end - 1];
                if (val2 == '+') {
                    out[--wpos] = (char)val;
                    break;
                }
                if (val2 == '-') {
                    out[--wpos] = (char)val;
                    neg = !neg;
                    break;
                }
                --end;
                val += (val2 - 48) * 10;
            }
            out[--wpos] = (char)val;
        }
        while (wpos < outend && out[wpos] == '\u0000') {
            ++wpos;
        }
        if (wpos != outend && neg) {
            out[--wpos] = 126;
        }
        return wpos;
    }

    public static int base100toBase10(char[] arr, int start, int end, char[] out, int offset) {
        int wpos = offset;
        boolean firstDigit = true;
        for (int i = start; i < end; ++i) {
            char val = arr[i];
            if (val == '~') {
                out[wpos++] = 45;
                continue;
            }
            char tens = (char)(val / 10 + 48);
            if (!firstDigit || tens != '0') {
                out[wpos++] = (char)(val / 10 + 48);
            }
            out[wpos++] = (char)(val % 10 + 48);
            firstDigit = false;
        }
        if (firstDigit) {
            out[wpos++] = 48;
        }
        return wpos - offset;
    }

    public static String base10toBase100SortableInt(String val) {
        char[] arr = new char[val.length() + 1];
        val.getChars(0, val.length(), arr, 0);
        int len = BCDUtils.base10toBase100SortableInt(arr, 0, val.length(), arr, arr.length);
        return new String(arr, arr.length - len, len);
    }

    public static String base100SortableIntToBase10(String val) {
        int slen = val.length();
        char[] arr = new char[slen << 2];
        val.getChars(0, slen, arr, 0);
        int len = BCDUtils.base100SortableIntToBase10(arr, 0, slen, arr, slen);
        return new String(arr, slen, len);
    }

    public static String base10toBase10kSortableInt(String val) {
        char[] arr = new char[val.length() + 1];
        val.getChars(0, val.length(), arr, 0);
        int len = BCDUtils.base10toBase10kSortableInt(arr, 0, val.length(), arr, arr.length);
        return new String(arr, arr.length - len, len);
    }

    public static String base10kSortableIntToBase10(String val) {
        int slen = val.length();
        char[] arr = new char[slen * 5];
        val.getChars(0, slen, arr, 0);
        int len = BCDUtils.base10kSortableIntToBase10(arr, 0, slen, arr, slen);
        return new String(arr, slen, len);
    }

    public static int base10toBase100SortableInt(char[] arr, int start, int end, char[] out, int outend) {
        int wpos = outend;
        boolean neg = false;
        --end;
        while (start <= end) {
            char val = arr[start];
            if (val == '-') {
                neg = !neg;
            } else if (val >= '1' && val <= '9') break;
            ++start;
        }
        block4: while (start <= end) {
            switch (arr[end]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --end;
                    continue block4;
                }
            }
        }
        int hundreds = 0;
        while (start <= end) {
            int val = arr[end--];
            val -= 48;
            if (start <= end) {
                char val2 = arr[end--];
                val += (val2 - 48) * 10;
            }
            out[--wpos] = neg ? (char)(99 - val) : (char)val;
        }
        hundreds += outend - wpos;
        out[--wpos] = neg ? (char)(97 - hundreds) : (char)(97 + hundreds);
        return outend - wpos;
    }

    public static int base100SortableIntToBase10(char[] arr, int start, int end, char[] out, int offset) {
        int exp;
        if (end - start == 1) {
            out[offset] = 48;
            return 1;
        }
        int wpos = offset;
        boolean neg = false;
        if ((exp = arr[start++]) < 97) {
            neg = true;
            exp = 97 - exp;
            out[wpos++] = 45;
        }
        boolean firstDigit = true;
        while (start < end) {
            int val = arr[start++];
            if (neg) {
                val = 99 - val;
            }
            char tens = (char)(val / 10 + 48);
            if (!firstDigit || tens != '0') {
                out[wpos++] = tens;
            }
            out[wpos++] = (char)(val % 10 + 48);
            firstDigit = false;
        }
        return wpos - offset;
    }

    public static int base10toBase10kSortableInt(char[] arr, int start, int end, char[] out, int outend) {
        int wpos = outend;
        boolean neg = false;
        --end;
        while (start <= end) {
            char val = arr[start];
            if (val == '-') {
                neg = !neg;
            } else if (val >= '1' && val <= '9') break;
            ++start;
        }
        block4: while (start <= end) {
            switch (arr[end]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --end;
                    continue block4;
                }
            }
        }
        int exp = 0;
        while (start <= end) {
            int val = arr[end--] - 48;
            if (start <= end) {
                val += (arr[end--] - 48) * 10;
                if (start <= end) {
                    val += (arr[end--] - 48) * 100;
                    if (start <= end) {
                        val += (arr[end--] - 48) * 1000;
                    }
                }
            }
            out[--wpos] = neg ? (char)(9999 - val) : (char)val;
        }
        exp += outend - wpos;
        out[--wpos] = neg ? (char)(97 - exp) : (char)(97 + exp);
        return outend - wpos;
    }

    public static int base10kSortableIntToBase10(char[] arr, int start, int end, char[] out, int offset) {
        int hundreds;
        int tens;
        int ones;
        int div;
        boolean neg;
        char exp;
        if (end - start == 1) {
            out[offset] = 48;
            return 1;
        }
        int wpos = offset;
        if ((exp = arr[start++]) < 'a') {
            neg = true;
            out[wpos++] = 45;
        } else {
            neg = false;
        }
        int val = arr[start++];
        if (neg) {
            val = 9999 - val;
        }
        if (val < 10) {
            out[wpos++] = (char)(val + 48);
        } else if (val < 100) {
            div = BCDUtils.div10(val);
            ones = val - BCDUtils.mul10(div);
            out[wpos++] = (char)(div + 48);
            out[wpos++] = (char)(ones + 48);
        } else if (val < 1000) {
            div = BCDUtils.div10(val);
            ones = val - BCDUtils.mul10(div);
            val = div;
            div = BCDUtils.div10(val);
            tens = val - BCDUtils.mul10(div);
            out[wpos++] = (char)(div + 48);
            out[wpos++] = (char)(tens + 48);
            out[wpos++] = (char)(ones + 48);
        } else {
            div = BCDUtils.div10(val);
            ones = val - BCDUtils.mul10(div);
            val = div;
            div = BCDUtils.div10(val);
            tens = val - BCDUtils.mul10(div);
            val = div;
            div = BCDUtils.div10(val);
            hundreds = val - BCDUtils.mul10(div);
            out[wpos++] = (char)(div + 48);
            out[wpos++] = (char)(hundreds + 48);
            out[wpos++] = (char)(tens + 48);
            out[wpos++] = (char)(ones + 48);
        }
        while (start < end) {
            val = arr[start++];
            if (neg) {
                val = 9999 - val;
            }
            div = BCDUtils.div10(val);
            ones = val - BCDUtils.mul10(div);
            val = div;
            div = BCDUtils.div10(val);
            tens = val - BCDUtils.mul10(div);
            val = div;
            div = BCDUtils.div10(val);
            hundreds = val - BCDUtils.mul10(div);
            out[wpos++] = (char)(div + 48);
            out[wpos++] = (char)(hundreds + 48);
            out[wpos++] = (char)(tens + 48);
            out[wpos++] = (char)(ones + 48);
        }
        return wpos - offset;
    }
}

