/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class UniqFieldsUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private Set<String> fields;

    @Override
    public void init(NamedList args) {
        NamedList flst = (NamedList)args.get("fields");
        if (flst != null) {
            this.fields = new HashSet<String>();
            for (int i = 0; i < flst.size(); ++i) {
                this.fields.add((String)flst.getVal(i));
            }
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UniqFieldsUpdateProcessor(next, this.fields);
    }

    public class UniqFieldsUpdateProcessor
    extends UpdateRequestProcessor {
        private final Set<String> fields;

        public UniqFieldsUpdateProcessor(UpdateRequestProcessor next, Set<String> fields) {
            super(next);
            this.fields = fields;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (this.fields != null) {
                SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
                ArrayList uniqList = new ArrayList();
                for (String field : this.fields) {
                    uniqList.clear();
                    Collection col = solrInputDocument.getFieldValues(field);
                    if (col == null) continue;
                    for (Object o : col) {
                        if (uniqList.contains(o)) continue;
                        uniqList.add(o);
                    }
                    solrInputDocument.remove((Object)field);
                    for (Object o : uniqList) {
                        solrInputDocument.addField(field, o);
                    }
                }
            }
            super.processAdd(cmd);
        }
    }
}

