/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.servlet.FormDataRequestParser;
import org.apache.solr.servlet.MultipartRequestParser;
import org.apache.solr.servlet.RawRequestParser;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.SolrRequestParsers;

class StandardRequestParser
implements SolrRequestParser {
    MultipartRequestParser multipart;
    RawRequestParser raw;
    FormDataRequestParser formdata;

    StandardRequestParser(MultipartRequestParser multi, RawRequestParser raw, FormDataRequestParser formdata) {
        this.multipart = multi;
        this.raw = raw;
        this.formdata = formdata;
    }

    @Override
    public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
        String method = req.getMethod().toUpperCase(Locale.ROOT);
        if ("GET".equals(method) || "HEAD".equals(method) || "PUT".equals(method) && req.getRequestURI().contains("/schema")) {
            return SolrRequestParsers.parseQueryString(req.getQueryString());
        }
        if ("POST".equals(method)) {
            if (this.formdata.isFormData(req)) {
                return this.formdata.parseParamsAndFillStreams(req, streams);
            }
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                return this.multipart.parseParamsAndFillStreams(req, streams);
            }
            return this.raw.parseParamsAndFillStreams(req, streams);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported method: " + method + " for request " + req);
    }
}

