/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.servlet.FileItemContentStream;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.SolrRequestParsers;

class MultipartRequestParser
implements SolrRequestParser {
    private final int uploadLimitKB;

    public MultipartRequestParser(int limit) {
        this.uploadLimitKB = limit;
    }

    @Override
    public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not multipart content! " + req.getContentType());
        }
        MultiMapSolrParams params = SolrRequestParsers.parseQueryString(req.getQueryString());
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax((long)this.uploadLimitKB * 1024L);
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            if (item.isFormField()) {
                MultiMapSolrParams.addParam((String)item.getFieldName(), (String)item.getString(), (Map)params.getMap());
                continue;
            }
            streams.add((ContentStream)new FileItemContentStream(item));
        }
        return params;
    }
}

