/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;

public class ValueSourceAugmenter
extends DocTransformer {
    public final String name;
    public final QParser qparser;
    public final ValueSource valueSource;
    Map fcontext;
    SolrIndexSearcher searcher;
    List<AtomicReaderContext> readerContexts;
    FunctionValues[] docValuesArr;

    public ValueSourceAugmenter(String name, QParser qparser, ValueSource valueSource) {
        this.name = name;
        this.qparser = qparser;
        this.valueSource = valueSource;
    }

    @Override
    public String getName() {
        return "function(" + this.name + ")";
    }

    @Override
    public void setContext(TransformContext context) {
        try {
            DirectoryReader reader = this.qparser.getReq().getSearcher().getIndexReader();
            this.readerContexts = reader.leaves();
            this.docValuesArr = new FunctionValues[this.readerContexts.size()];
            this.searcher = this.qparser.getReq().getSearcher();
            this.fcontext = ValueSource.newContext((IndexSearcher)this.searcher);
            this.valueSource.createWeight(this.fcontext, (IndexSearcher)this.searcher);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        try {
            int localId;
            Object val;
            int idx = ReaderUtil.subIndex((int)docid, this.readerContexts);
            AtomicReaderContext rcontext = this.readerContexts.get(idx);
            FunctionValues values = this.docValuesArr[idx];
            if (values == null) {
                this.docValuesArr[idx] = values = this.valueSource.getValues(this.fcontext, rcontext);
            }
            if ((val = values.objectVal(localId = docid - rcontext.docBase)) != null) {
                doc.setField(this.name, val);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "exception at docid " + docid + " for valuesource " + this.valueSource, (Throwable)e);
        }
    }
}

