/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.logging.log4j.Log4jWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class LogWatcher<E> {
    private static final Logger log = LoggerFactory.getLogger(LogWatcher.class);
    protected CircularList<E> history;
    protected long last = -1L;

    public abstract String getName();

    public abstract List<String> getAllLevels();

    public abstract void setLogLevel(String var1, String var2);

    public abstract Collection<LoggerInfo> getAllLoggers();

    public abstract void setThreshold(String var1);

    public abstract String getThreshold();

    public void add(E event, long timstamp) {
        this.history.add(event);
        this.last = timstamp;
    }

    public long getLastEvent() {
        return this.last;
    }

    public int getHistorySize() {
        return this.history == null ? -1 : this.history.getBufferSize();
    }

    public SolrDocumentList getHistory(long since, AtomicBoolean found) {
        if (this.history == null) {
            return null;
        }
        SolrDocumentList docs = new SolrDocumentList();
        for (E e : this.history) {
            long ts = this.getTimestamp(e);
            if (ts == since && found != null) {
                found.set(true);
            }
            if (ts <= since) continue;
            docs.add((Object)this.toSolrDocument(e));
        }
        docs.setNumFound((long)docs.size());
        return docs;
    }

    public abstract long getTimestamp(E var1);

    public abstract SolrDocument toSolrDocument(E var1);

    public abstract void registerListener(ListenerConfig var1);

    public void reset() {
        this.history.clear();
        this.last = -1L;
    }

    public static LogWatcher newRegisteredLogWatcher(ConfigSolr config, SolrResourceLoader loader) {
        if (!config.getBool(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, true)) {
            return null;
        }
        LogWatcher logWatcher = LogWatcher.createWatcher(config, loader);
        if (logWatcher != null) {
            ListenerConfig v = new ListenerConfig();
            v.size = config.getInt(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, 50);
            v.threshold = config.get(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, null);
            if (v.size > 0) {
                log.info("Registering Log Listener [{}]", (Object)logWatcher.getName());
                logWatcher.registerListener(v);
            }
        }
        return logWatcher;
    }

    private static LogWatcher createWatcher(ConfigSolr config, SolrResourceLoader loader) {
        String slf4jImpl;
        String fname = config.get(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, null);
        try {
            slf4jImpl = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
            if (fname == null) {
                if (slf4jImpl.indexOf("Log4j") > 0) {
                    fname = "Log4j";
                } else if (slf4jImpl.indexOf("JDK") > 0) {
                    fname = "JUL";
                }
            }
        }
        catch (Throwable e) {
            log.warn("Unable to read SLF4J version.  LogWatcher will be disabled: " + e);
            return null;
        }
        if (fname == null) {
            log.info("No LogWatcher configured");
            return null;
        }
        if ("JUL".equalsIgnoreCase(fname)) {
            return new JulWatcher(slf4jImpl);
        }
        if ("Log4j".equals(fname)) {
            return new Log4jWatcher(slf4jImpl);
        }
        try {
            return loader != null ? loader.newInstance(fname, LogWatcher.class) : null;
        }
        catch (Throwable e) {
            log.warn("Unable to load LogWatcher {}: {}", (Object)fname, (Object)e);
            return null;
        }
    }
}

