/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.Problem;

class L2R_L2_SvcFunction
implements Function {
    protected final Problem prob;
    protected final double[] C;
    protected final int[] I;
    protected final double[] z;
    protected int sizeI;

    public L2R_L2_SvcFunction(Problem prob, double[] C) {
        int l = prob.l;
        this.prob = prob;
        this.z = new double[l];
        this.I = new int[l];
        this.C = C;
    }

    @Override
    public double fun(double[] w) {
        double f = 0.0;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.Xv(w, this.z);
        int i = 0;
        while (i < w_size) {
            f += w[i] * w[i];
            ++i;
        }
        f /= 2.0;
        i = 0;
        while (i < l) {
            this.z[i] = y[i] * this.z[i];
            double d = 1.0 - this.z[i];
            if (d > 0.0) {
                f += this.C[i] * d * d;
            }
            ++i;
        }
        return f;
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }

    @Override
    public void grad(double[] w, double[] g) {
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.sizeI = 0;
        int i = 0;
        while (i < l) {
            if (this.z[i] < 1.0) {
                this.z[this.sizeI] = this.C[i] * y[i] * (this.z[i] - 1.0);
                this.I[this.sizeI] = i;
                ++this.sizeI;
            }
            ++i;
        }
        this.subXTv(this.z, g);
        i = 0;
        while (i < w_size) {
            g[i] = w[i] + 2.0 * g[i];
            ++i;
        }
    }

    @Override
    public void Hv(double[] s, double[] Hs) {
        int w_size = this.get_nr_variable();
        double[] wa = new double[this.sizeI];
        this.subXv(s, wa);
        int i = 0;
        while (i < this.sizeI) {
            wa[i] = this.C[this.I[i]] * wa[i];
            ++i;
        }
        this.subXTv(wa, Hs);
        i = 0;
        while (i < w_size) {
            Hs[i] = s[i] + 2.0 * Hs[i];
            ++i;
        }
    }

    protected void subXTv(double[] v, double[] XTv) {
        int w_size = this.get_nr_variable();
        int i = 0;
        while (i < w_size) {
            XTv[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.sizeI) {
            Feature[] featureArray = this.prob.x[this.I[i]];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature s = featureArray[n2];
                int n3 = s.getIndex() - 1;
                XTv[n3] = XTv[n3] + v[i] * s.getValue();
                ++n2;
            }
            ++i;
        }
    }

    private void subXv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.sizeI) {
            Xv[i] = 0.0;
            Feature[] featureArray = this.prob.x[this.I[i]];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature s = featureArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.getIndex() - 1] * s.getValue();
                ++n2;
            }
            ++i;
        }
    }

    protected void Xv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.prob.l) {
            Xv[i] = 0.0;
            Feature[] featureArray = this.prob.x[i];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature s = featureArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.getIndex() - 1] * s.getValue();
                ++n2;
            }
            ++i;
        }
    }
}

