/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex.citation;

import java.util.List;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.Key;
import org.jbibtex.Value;
import org.jbibtex.citation.EntryFormat;
import org.jbibtex.citation.FieldFormat;
import org.jbibtex.citation.ReferenceStyle;

public class ReferenceFormatter {
    private ReferenceStyle style = null;

    public ReferenceFormatter(ReferenceStyle style) {
        this.setStyle(style);
    }

    public String format(BibTeXEntry entry, boolean html) {
        return this.format(entry, true, html);
    }

    public String format(BibTeXEntry entry, boolean latex, boolean html) {
        Key type;
        StringBuffer sb = new StringBuffer();
        ReferenceStyle style = this.getStyle();
        EntryFormat format = style.getFormat(type = entry.getType());
        if (format == null) {
            throw new IllegalArgumentException(type.getValue());
        }
        List<FieldFormat> fields = format.getFields();
        for (FieldFormat field : fields) {
            Key key = field.getKey();
            Value value = entry.getField(key);
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String string = field.format(value, latex, html);
            sb.append(string);
            this.ensureSuffix(sb, field.getSeparator());
        }
        this.ensureSuffix(sb, fields.get(fields.size() - 1).getSeparator());
        return sb.toString();
    }

    private void ensureSuffix(StringBuffer sb, String separator) {
        if (separator != null && !ReferenceFormatter.hasSuffix(sb, separator)) {
            sb.append(separator);
        }
    }

    public ReferenceStyle getStyle() {
        return this.style;
    }

    private void setStyle(ReferenceStyle style) {
        this.style = style;
    }

    private static boolean hasSuffix(StringBuffer sb, String string) {
        return sb.length() >= string.length() && sb.substring(sb.length() - string.length(), sb.length()).equals(string);
    }
}

