/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.header.ChallengeRequestReader;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorUtils {
    public static boolean anyNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static String formatAuthenticationInfo(AuthenticationInfo info) {
        ChallengeWriter cw = new ChallengeWriter();
        boolean firstParameter = true;
        if (info != null) {
            if (info.getNextServerNonce() != null && info.getNextServerNonce().length() > 0) {
                cw.setFirstChallengeParameter(firstParameter);
                cw.appendQuotedChallengeParameter("nextnonce", info.getNextServerNonce());
                firstParameter = false;
            }
            if (info.getQuality() != null && info.getQuality().length() > 0) {
                cw.setFirstChallengeParameter(firstParameter);
                cw.appendChallengeParameter("qop", info.getQuality());
                firstParameter = false;
                if (info.getNonceCount() > 0) {
                    cw.appendChallengeParameter("nc", AuthenticatorUtils.formatNonceCount(info.getNonceCount()));
                }
            }
            if (info.getResponseDigest() != null && info.getResponseDigest().length() > 0) {
                cw.setFirstChallengeParameter(firstParameter);
                cw.appendQuotedChallengeParameter("rspauth", info.getResponseDigest());
                firstParameter = false;
            }
            if (info.getClientNonce() != null && info.getClientNonce().length() > 0) {
                cw.setFirstChallengeParameter(firstParameter);
                cw.appendChallengeParameter("cnonce", info.getClientNonce());
                firstParameter = false;
            }
        }
        return cw.toString();
    }

    public static String formatNonceCount(int nonceCount) {
        StringBuilder result = new StringBuilder(Integer.toHexString(nonceCount));
        while (result.length() < 8) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    public static String formatRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) {
        String result = null;
        if (challenge == null) {
            Context.getCurrentLogger().warning("No challenge response to format.");
        } else if (challenge.getScheme() == null) {
            Context.getCurrentLogger().warning("A challenge response must have a scheme defined.");
        } else if (challenge.getScheme().getTechnicalName() == null) {
            Context.getCurrentLogger().warning("A challenge scheme must have a technical name defined.");
        } else {
            ChallengeWriter cw = new ChallengeWriter();
            ((HeaderWriter)cw.append(challenge.getScheme().getTechnicalName())).appendSpace();
            int cwInitialLength = cw.getBuffer().length();
            if (challenge.getRawValue() != null) {
                cw.append(challenge.getRawValue());
            } else {
                AuthenticatorHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), false, true);
                if (helper != null) {
                    try {
                        helper.formatRequest(cw, challenge, response, httpHeaders);
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to format the challenge request: " + challenge, e);
                    }
                } else {
                    result = "?";
                    Context.getCurrentLogger().warning("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
                }
            }
            result = cw.getBuffer().length() > cwInitialLength ? cw.toString() : null;
        }
        return result;
    }

    public static String formatResponse(ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        String result = null;
        if (challenge == null) {
            Context.getCurrentLogger().warning("No challenge response to format.");
        } else if (challenge.getScheme() == null) {
            Context.getCurrentLogger().warning("A challenge response must have a scheme defined.");
        } else if (challenge.getScheme().getTechnicalName() == null) {
            Context.getCurrentLogger().warning("A challenge scheme must have a technical name defined.");
        } else {
            ChallengeWriter cw = new ChallengeWriter();
            ((HeaderWriter)cw.append(challenge.getScheme().getTechnicalName())).appendSpace();
            int cwInitialLength = cw.getBuffer().length();
            if (challenge.getRawValue() != null) {
                cw.append(challenge.getRawValue());
            } else {
                AuthenticatorHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), true, false);
                if (helper != null) {
                    try {
                        helper.formatResponse(cw, challenge, request, httpHeaders);
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to format the challenge response: " + challenge, e);
                    }
                } else {
                    Context.getCurrentLogger().warning("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
                }
            }
            result = cw.getBuffer().length() > cwInitialLength ? cw.toString() : null;
        }
        return result;
    }

    public static AuthenticationInfo parseAuthenticationInfo(String header) {
        AuthenticationInfo result = null;
        HeaderReader hr = new HeaderReader(header);
        try {
            String nextNonce = null;
            String qop = null;
            String responseAuth = null;
            String cnonce = null;
            int nonceCount = 0;
            Parameter param = hr.readParameter();
            while (param != null) {
                try {
                    if ("nextnonce".equals(param.getName())) {
                        nextNonce = param.getValue();
                    } else if ("qop".equals(param.getName())) {
                        qop = param.getValue();
                    } else if ("rspauth".equals(param.getName())) {
                        responseAuth = param.getValue();
                    } else if ("cnonce".equals(param.getName())) {
                        cnonce = param.getValue();
                    } else if ("nc".equals(param.getName())) {
                        nonceCount = Integer.parseInt(param.getValue(), 16);
                    }
                    if (hr.skipValueSeparator()) {
                        param = hr.readParameter();
                        continue;
                    }
                    param = null;
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the authentication info header parameter", e);
                }
            }
            result = new AuthenticationInfo(nextNonce, nonceCount, cnonce, qop, responseAuth);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the authentication info header: " + header, e);
        }
        return result;
    }

    public static List<ChallengeRequest> parseRequest(Response response, String header, Series<Header> httpHeaders) {
        List<ChallengeRequest> result = new ArrayList<ChallengeRequest>();
        if (header != null) {
            result = new ChallengeRequestReader(header).readValues();
            for (ChallengeRequest cr : result) {
                AuthenticatorHelper helper = Engine.getInstance().findHelper(cr.getScheme(), true, false);
                if (helper != null) {
                    helper.parseRequest(cr, response, httpHeaders);
                    continue;
                }
                Context.getCurrentLogger().warning("Couldn't find any helper support the " + cr.getScheme() + " challenge scheme.");
            }
        }
        return result;
    }

    public static ChallengeResponse parseResponse(Request request, String header, Series<Header> httpHeaders) {
        int space;
        ChallengeMessage result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String rawValue = header.substring(space + 1);
            result = new ChallengeResponse(new ChallengeScheme("HTTP_" + scheme, scheme));
            result.setRawValue(rawValue);
        }
        if (result != null) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(result.getScheme(), true, false);
            if (helper != null) {
                helper.parseResponse((ChallengeResponse)result, request, httpHeaders);
            } else {
                Context.getCurrentLogger().warning("Couldn't find any helper support the " + result.getScheme() + " challenge scheme.");
            }
        }
        return result;
    }

    public static void update(ChallengeResponse challengeResponse, Request request, Response response) {
        ChallengeMessage challengeRequest = null;
        for (ChallengeRequest c : response.getChallengeRequests()) {
            if (!challengeResponse.getScheme().equals(c.getScheme())) continue;
            challengeRequest = c;
            break;
        }
        String realm = null;
        String nonce = null;
        if (challengeRequest != null) {
            realm = challengeRequest.getRealm();
            nonce = challengeRequest.getServerNonce();
            challengeResponse.setOpaque(challengeRequest.getOpaque());
        }
        challengeResponse.setRealm(realm);
        challengeResponse.setServerNonce(nonce);
        challengeResponse.setDigestRef(new Reference(request.getResourceRef().getPath()));
    }

    public static Reference updateReference(Reference resourceRef, ChallengeResponse challengeResponse, Request request) {
        if (challengeResponse != null) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(challengeResponse.getScheme(), true, false);
            if (helper != null) {
                resourceRef = helper.updateReference(resourceRef, challengeResponse, request);
            } else {
                Context.getCurrentLogger().warning("Challenge scheme " + challengeResponse.getScheme() + " not supported by the Restlet engine.");
            }
        }
        return resourceRef;
    }

    private AuthenticatorUtils() {
    }
}

