/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.log;

import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingThreadFactory
implements ThreadFactory {
    private final Logger logger;
    private final boolean daemon;

    public LoggingThreadFactory(Logger logger) {
        this(logger, false);
    }

    public LoggingThreadFactory(Logger logger, boolean daemon) {
        this.logger = logger;
        this.daemon = daemon;
    }

    public Thread newThread(Runnable r) {
        Thread result = new Thread(r);
        result.setName("Restlet-" + result.hashCode());
        result.setUncaughtExceptionHandler(new LoggingExceptionHandler());
        result.setDaemon(this.daemon);
        return result;
    }

    private class LoggingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LoggingExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable ex) {
            LoggingThreadFactory.this.logger.log(Level.SEVERE, "Thread: " + t.getName() + " terminated with exception: " + ex.getMessage(), ex);
        }
    }
}

